/*
 * \ingroup imsa
 *
 * \file qaImsaSLQSGetSupportedFields.h
 *
 * \brief  This file contains definitions, enumerations, structures and
 *         forward declarations for qaImsaSLQSGetSupportedFields.c
 *
 * Copyright: © 2015 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __IMSA_SLQS_GET_SUPPORTED_FIELDS_H__
#define __IMSA_SLQS_GET_SUPPORTED_FIELDS_H__

/* enum declarations */

/*
 * An enumeration of eQMI_IMSA_SLQS_IND_REGISTER request TLV IDs
 */
enum eQMI_IMSA_SLQS_GET_FIELDS_REQ
{
    eTLV_IMSA_SERVICE_MSG_ID     = 0x01
};

enum eQMI_IMSA_SLQS_GET_FIELDS_RESP
{
    eTLV_IMSA_SUPPORT_REQ_FIELDS_LIST      = 0x10,
    eTLV_IMSA_SUPPORT_RESP_FIELDS_LIST     = 0x11,
    eTLV_IMSA_SUPPORT_IND_FIELDS_LIST      = 0x12,
};

/*
 * This structure contains the SLQSRegisterIMSAIndication response
 * parameters.
 *
 */
struct QmiImsaGetSupportFieldsResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;

    /* Get Supported Fields response parameters */
    IMSASupportedFieldsResp *pIMSASupportedFieldsResp;
};
/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiImsaSLQSGetSupportFields(
    WORD *pMlength,
    BYTE *pParamField,
    WORD messageId);

extern enum eQCWWANError UpkQmiImsaSLQSGetSupportFields(
    BYTE                            *pMdmResp,
    struct QmiImsaGetSupportFieldsResp *pApiResp);

#endif /* __IMSA_SLQS_GET_SUPPORTED_FIELDS_H__ */
