/*
 * \ingroup imsa
 *
 * \file qaImsaSLQSGetServiceStatus.h
 *
 * \brief  This file contains definitions, enumerations, structures and
 *         forward declarations for qaImsaSLQSGetServiceStatus.c
 *
 * Copyright: © 2015 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __IMSA_SLQS_GET_SERVICE_STATUS_H__
#define __IMSA_SLQS_GET_SERVICE_STATUS_H__

/* enum declarations */

/*
 * An enumeration of eQMI_IMSA_GET_SERVICE_STATUS request TLV IDs
 */
enum eQMI_IMSA_GET_SERVICE_STATUS_RESP
{
    eTLV_IMSA_SMS_SERVICE_STATUS     = 0x10,
    eTLV_IMSA_VOIP_SERVICE_STATUS     = 0x11,
    eTLV_IMSA_VT_SERVICE_STATUS       = 0x12,
    eTLV_IMSA_SMS_SERVICE_RAT         = 0x13,
    eTLV_IMSA_VOIP_SERVICE_RAT        = 0x14,
    eTLV_IMSA_VT_SERVICE_RAT          = 0x15,
    eTLV_IMSA_UT_SERVICE_STATUS       = 0x16,
    eTLV_IMSA_UT_SERVICE_RAT          = 0x17,
    eTLV_IMSA_VS_SERVICE_STATUS       = 0x18,
    eTLV_IMSA_VS_SERVICE_RAT          = 0x19
};

/*
 * This structure contains the SLQSGetIMSAServiceStatus response
 * parameters.
 *
 */
struct QmiImsaGetServiceStatusResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;

    /* Get Registration Status response parameters */
    IMSAServiceStatus *pIMSAServiceStatus;
};
/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiImsaSLQSGetServiceStatus(
    WORD *pMlength,
    BYTE *pParamField);

extern enum eQCWWANError UpkQmiImsaSLQSGetServiceStatus(
    BYTE                               *pMdmResp,
    struct QmiImsaGetServiceStatusResp *pApiResp);

#endif /* __IMSA_SLQS_GET_SERVICE_STATUS_H__ */
