/*
 * \ingroup imsa
 *
 * \file qaImsaSLQSGetRegistrationStatus.h
 *
 * \brief  This file contains definitions, enumerations, structures and
 *         forward declarations for qaImsaSLQSGetRegistrationStatus.c
 *
 * Copyright: © 2015 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __IMSA_SLQS_GET_REG_STATUS_H__
#define __IMSA_SLQS_GET_REG_STATUS_H__

/* enum declarations */

/*
 * An enumeration of eQMI_IMSA_GET_REGISTRATION_STATUS request TLV IDs
 */
enum eQMI_IMSA_GET_REGISTRATION_STATUS_RESP
{
    eTLV_IMSA_REG_STATUS     = 0x10,
    eTLV_IMSA_REG_ERROR_CODE = 0x11,
    eTLV_IMSA_NEW_REG_STATUS = 0x12
};

/*
 * This structure contains the SLQSGetIMSARegStatus response
 * parameters.
 *
 */
struct QmiImsaGetRegStatusResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;

    /* Get Registration Status response parameters */
    IMSARegistrationStatus *pIMSARegistrationStatus;
};
/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiImsaSLQSGetRegStatus(
    WORD *pMlength,
    BYTE *pParamField);

extern enum eQCWWANError UpkQmiImsaSLQSGetRegStatus(
    BYTE                            *pMdmResp,
    struct QmiImsaGetRegStatusResp *pApiResp);

#endif /* __IMSA_SLQS_GET_REG_STATUS_H__ */
