/*
 * \ingroup dms
 *
 * \file    qaDmsSLQSSwiSetUSBComp.c
 *
 * \brief   Contains Packing and UnPacking routines for the
 *          eQMI_DMS_SWI_SET_USB_COMP message.
 *
 * Copyright: © 2014 Sierra Wireless, Inc. all rights reserved
 *
 */

/* include files */
#include "SwiDataTypes.h"
#include "qmudefs.h"
#include "qmerrno.h"
#include "qaGobiApiDms.h"
#include "qaDmsSLQSSwiSetUSBComp.h"

/*****************************************************************************
 * Request handling
 *****************************************************************************/
/*
 * This function packs the USB composition value to the QMI message SDU.
 *
 * \param  pBuf   [OUT] - Pointer to storage into which the packed
 *                        data will be placed by this function.
 *
 * \param  pParam [IN]  - Pointer to structure containing data for this TLV.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 */
enum eQCWWANError BuildTlvSetUSBComp( BYTE *pBuf, BYTE *pParam )
{
    USBCompConfig *pReq = ( USBCompConfig* )pParam;
    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    /* Check For Null Parameter */
    if ( NULL == pReq->pUSBComp )
    {
        return eQCWWAN_ERR_INVALID_ARG;
    }

    /* Insert USB Composition */
    eRCode = PutByte( pBuf, *(pReq->pUSBComp) );

    return eRCode;
}
/*
 * This function packs the SLQSSwiSetUSBComp request parameters to
 * the QMI message SDU
 *
 * \param  pMlength     [OUT] - Total length of built message.
 *
 * \param  pParamField  [OUT] - Pointer to storage into which the packed data
 *                              will be placed by this function.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 */
enum eQCWWANError PkQmiDmsSLQSSwiSetUSBComp(
    WORD          *pMlength,
    BYTE          *pParamField,
    USBCompConfig *pUSBCompConfig )
{
    static struct qmTlvBuilderItem map[] =
    {
        { eTLV_DMS_SET_USB_COMP, &BuildTlvSetUSBComp },
        { eTLV_TYPE_INVALID,     NULL }/* Important. Sentinel.
                                        * Signifies last item in map
                                        */
    };

    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    eRCode =  qmbuild( pParamField,
                       (BYTE*)pUSBCompConfig,
                       map,
                       eQMI_DMS_SWI_SET_USB_COMP,
                       pMlength );
    return eRCode;
}

/*****************************************************************************
 * Response handling
 *****************************************************************************/
/*
 * This function unpacks the SLQSSwiSetUSBComp response to a
 * user-provided response structure.
 *
 * \param  pMdmResp           - Pointer to packed response from the modem.
 *
 * \param  pApiResp           - Pointer to storage to unpack into.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 */
enum eQCWWANError UpkQmiDmsSLQSSwiSetUSBComp(
    BYTE                               *pMdmResp,
    struct QmiDmsSLQSSwiSetUSBCompResp *pApiResp )
{
    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    static struct qmTlvUnpackerItem map[] =
    {
        { eTLV_RESULT_CODE,  &qmUnpackTlvResultCode },
        { eTLV_TYPE_INVALID, NULL } /* Important. Sentinel.
                                     * Signifies last item in map.
                                     */
    };

    eRCode = qmunpackresp( pMdmResp,
                           (BYTE *)pApiResp,
                           map,
                           eQMI_DMS_SWI_SET_USB_COMP );
    return eRCode;
}
