/*
 * \ingroup dms
 *
 * \file    qaDmsSLQSSwiSetOSInfo.c
 *
 * \brief   Contains Packing and UnPacking routines for the
 *          QmiDmsSLQSSwiSetOSInfoResp message.
 *
 * Copyright: Â© 2014 Sierra Wireless, Inc. all rights reserved
 *
 */

/* include files */
#include "SwiDataTypes.h"
#include "qmudefs.h"
#include "qmerrno.h"
#include "qaGobiApiDms.h"
#include "qaDmsSLQSSwiSetOSInfo.h"

/*****************************************************************************
 * Request handling
 *****************************************************************************/
/*
 * This function packs the Host Device Manufacturer value to the QMI message .
 *
 * \param  pBuf   [OUT] - Pointer to storage into which the packed
 *                        data will be placed by this function.
 *
 * \param  pParam [IN]  - Pointer to structure containing data for this TLV.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 */
enum eQCWWANError BuildTlvSetName( BYTE *pBuf, BYTE *pParam )
{
    struct QmiDmsSLQSSwiSetOSInfoReq *pReq = (struct QmiDmsSLQSSwiSetOSInfoReq* )pParam;
    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    /* Check For Null Parameter */
    if ( 0 == pReq->pNameString )
    {
        return eQCWWAN_ERR_INVALID_ARG;
    }
	int i=0;
	for(i=0; i<pReq->bNameSize; i++)
	{
		if ( eRCode == eQCWWAN_ERR_NONE )
		{
			eRCode = PutByte(pBuf, *(pReq->pNameString)++);
		}
		else
		{
			break;
		}
	}
    return eRCode;
}

/*
 * This function packs the Host Device Model value to the QMI message .
 *
 * \param  pBuf   [OUT] - Pointer to storage into which the packed
 *                        data will be placed by this function.
 *
 * \param  pParam [IN]  - Pointer to structure containing data for this TLV.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 */
enum eQCWWANError BuildTlvSetVersion( BYTE *pBuf, BYTE *pParam )
{
    struct QmiDmsSLQSSwiSetOSInfoReq *pReq = (struct QmiDmsSLQSSwiSetOSInfoReq* )pParam;
    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    /* Check For Null Parameter */
    if ( 0 == pReq->pVersionString )
    {
        return eQCWWAN_ERR_INVALID_ARG;
    }
	int i=0;
	for(i=0; i<pReq->bVersionSize; i++)
	{
		if ( eRCode == eQCWWAN_ERR_NONE )
		{
			eRCode = PutByte(pBuf, *(pReq->pVersionString)++);
		}
		else
		{
			break;
		}
	}
    return eRCode;
}

/*
 * This function packs the SLQSSwiSetOSInfo request parameters to
 * the QMI message SDU
 *
 * \param  pMlength     [OUT] - Total length of built message.
 *
 * \param  pParamField  [OUT] - Pointer to storage into which the packed data
 *                              will be placed by this function.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 */
enum eQCWWANError PkQmiDmsSLQSSwiSetOSInfo(
    WORD          *pMlength,
    BYTE          *pParamField,
    struct QmiDmsSLQSSwiSetOSInfoReq *pReq )
{
    static struct qmTlvBuilderItem map[] =
    {
        { eTLV_DMS_SET_OS_INFO_NAME,    &BuildTlvSetName },
		{ eTLV_DMS_SET_OS_INFO_VERSION, &BuildTlvSetVersion },
        { eTLV_TYPE_INVALID,     NULL }/* Important. Sentinel.
                                        * Signifies last item in map
                                        */
    };

    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    eRCode =  qmbuild( pParamField,
                       (BYTE*)pReq,
                       map,
                       eQMI_DMS_SWI_SET_OS_INFO,
                       pMlength );
    return eRCode;
}

/*****************************************************************************
 * Response handling
 *****************************************************************************/
/*
 * This function unpacks the qaDmsSLQSSwiSetOSInfo response to a
 * user-provided response structure.
 *
 * \param  pMdmResp           - Pointer to packed response from the modem.
 *
 * \param  pApiResp           - Pointer to storage to unpack into.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 */
enum eQCWWANError UpkQmiDmsSLQSSwiSetOSInfo(
    BYTE                               *pMdmResp,
    struct QmiDmsSLQSSwiSetOSInfoResp *pApiResp )
{
    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    static struct qmTlvUnpackerItem map[] =
    {
        { eTLV_RESULT_CODE,  &qmUnpackTlvResultCode },
        { eTLV_TYPE_INVALID, NULL } /* Important. Sentinel.
                                     * Signifies last item in map.
                                     */
    };

    eRCode = qmunpackresp( pMdmResp,
                           (BYTE *)pApiResp,
                           map,
                           eQMI_DMS_SWI_SET_OS_INFO );
    return eRCode;
}
