/*
 * \ingroup dms
 *
 * \file    qaDmsSLQSSwiSetHostDevInfo.c
 *
 * \brief   Contains Packing and UnPacking routines for the
 *          QmiDmsSLQSSwiSetHostDevInfoResp message.
 *
 * Copyright: Â© 2014 Sierra Wireless, Inc. all rights reserved
 *
 */

/* include files */
#include "SwiDataTypes.h"
#include "qmudefs.h"
#include "qmerrno.h"
#include "qaGobiApiDms.h"
#include "qaDmsSLQSSwiSetHostDevInfo.h"

/*****************************************************************************
 * Request handling
 *****************************************************************************/
/*
 * This function packs the Host Device Manufacturer value to the QMI message .
 *
 * \param  pBuf   [OUT] - Pointer to storage into which the packed
 *                        data will be placed by this function.
 *
 * \param  pParam [IN]  - Pointer to structure containing data for this TLV.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 */
enum eQCWWANError BuildTlvSetManufacturer( BYTE *pBuf, BYTE *pParam )
{
    struct QmiDmsSLQSSwiSetHostDevInfoReq *pReq = (struct QmiDmsSLQSSwiSetHostDevInfoReq* )pParam;
    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    /* Check For Null Parameter */
    if ( 0 == pReq->pManString )
    {
        return eQCWWAN_ERR_INVALID_ARG;
    }
	int i=0;
	for(i=0; i<pReq->bManSize; i++)
	{
		if ( eRCode == eQCWWAN_ERR_NONE )
		{
			eRCode = PutByte(pBuf, *(pReq->pManString)++);
		}
		else
		{
			break;
		}
	}
    return eRCode;
}

/*
 * This function packs the Host Device Model value to the QMI message .
 *
 * \param  pBuf   [OUT] - Pointer to storage into which the packed
 *                        data will be placed by this function.
 *
 * \param  pParam [IN]  - Pointer to structure containing data for this TLV.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 */
enum eQCWWANError BuildTlvSetModel( BYTE *pBuf, BYTE *pParam )
{
    struct QmiDmsSLQSSwiSetHostDevInfoReq *pReq = (struct QmiDmsSLQSSwiSetHostDevInfoReq* )pParam;
    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    /* Check For Null Parameter */
    if ( 0 == pReq->pModelString )
    {
        return eQCWWAN_ERR_INVALID_ARG;
    }
	int i=0;
	for(i=0; i<pReq->bModelSize; i++)
	{
		if ( eRCode == eQCWWAN_ERR_NONE )
		{
			eRCode = PutByte(pBuf, *(pReq->pModelString)++);
		}
		else
		{
			break;
		}
	}
    return eRCode;
}

/*
 * This function packs the Host Device Software Version value to the QMI message .
 *
 * \param  pBuf   [OUT] - Pointer to storage into which the packed
 *                        data will be placed by this function.
 *
 * \param  pParam [IN]  - Pointer to structure containing data for this TLV.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 */
enum eQCWWANError BuildTlvSetSoftwareVersion( BYTE *pBuf, BYTE *pParam )
{
    struct QmiDmsSLQSSwiSetHostDevInfoReq *pReq = (struct QmiDmsSLQSSwiSetHostDevInfoReq* )pParam;
    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    /* Check For Null Parameter */
    if ( 0 == pReq->pSWVerString )
    {
        return eQCWWAN_ERR_INVALID_ARG;
    }
	int i=0;
	for(i=0; i<pReq->bSWVerSize; i++)
	{
		if ( eRCode == eQCWWAN_ERR_NONE )
		{
			eRCode = PutByte(pBuf, *(pReq->pSWVerString)++);
		}
		else
		{
			break;
		}
	}
    return eRCode;
}

/*
 * This function packs the Host Device Plasma ID value to the QMI message .
 *
 * \param  pBuf   [OUT] - Pointer to storage into which the packed
 *                        data will be placed by this function.
 *
 * \param  pParam [IN]  - Pointer to structure containing data for this TLV.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 */
enum eQCWWANError BuildTlvSetPlasmaID( BYTE *pBuf, BYTE *pParam )
{
    struct QmiDmsSLQSSwiSetHostDevInfoReq *pReq = (struct QmiDmsSLQSSwiSetHostDevInfoReq* )pParam;
    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    /* Check For Null Parameter */
    if ( 0 == pReq->pPlasmaIDString )
    {
        return eQCWWAN_ERR_INVALID_ARG;
    }
	int i=0;
	for(i=0; i<pReq->bPlasmaIDSize; i++)
	{
		if ( eRCode == eQCWWAN_ERR_NONE )
		{
			eRCode = PutByte(pBuf, *(pReq->pPlasmaIDString)++);
		}
		else
		{
			break;
		}
	}
    return eRCode;
}
/*
 * This function packs the SLQSSwiSetHostDevInfo request parameters to
 * the QMI message SDU
 *
 * \param  pMlength     [OUT] - Total length of built message.
 *
 * \param  pParamField  [OUT] - Pointer to storage into which the packed data
 *                              will be placed by this function.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 */
enum eQCWWANError PkQmiDmsSLQSSwiSetHostDevInfo(
    WORD          *pMlength,
    BYTE          *pParamField,
    struct QmiDmsSLQSSwiSetHostDevInfoReq *pReq )
{
    static struct qmTlvBuilderItem map[] =
    {
        { eTLV_DMS_SET_HOST_DEV_INFO_MANUFACTURER,		&BuildTlvSetManufacturer },
		{ eTLV_DMS_SET_HOST_DEV_INFO_MODEL, 			&BuildTlvSetModel },
		{ eTLV_DMS_SET_HOST_DEV_INFO_SOFTWARE_VERSION,	&BuildTlvSetSoftwareVersion },
		{ eTLV_DMS_SET_HOST_DEV_INFO_PLASMA_ID,			&BuildTlvSetPlasmaID },
        { eTLV_TYPE_INVALID,     NULL }/* Important. Sentinel.
                                        * Signifies last item in map
                                        */
    };

    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    eRCode =  qmbuild( pParamField,
                       (BYTE*)pReq,
                       map,
                       eQMI_DMS_SWI_SET_HOST_DEV_INFO,
                       pMlength );
    return eRCode;
}

/*****************************************************************************
 * Response handling
 *****************************************************************************/
/*
 * This function unpacks the qaDmsSLQSSwiSetHostDevInfo response to a
 * user-provided response structure.
 *
 * \param  pMdmResp           - Pointer to packed response from the modem.
 *
 * \param  pApiResp           - Pointer to storage to unpack into.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 */
enum eQCWWANError UpkQmiDmsSLQSSwiSetHostDevInfo(
    BYTE                               *pMdmResp,
    struct QmiDmsSLQSSwiSetHostDevInfoResp *pApiResp )
{
    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    static struct qmTlvUnpackerItem map[] =
    {
        { eTLV_RESULT_CODE,  &qmUnpackTlvResultCode },
        { eTLV_TYPE_INVALID, NULL } /* Important. Sentinel.
                                     * Signifies last item in map.
                                     */
    };

    eRCode = qmunpackresp( pMdmResp,
                           (BYTE *)pApiResp,
                           map,
                           eQMI_DMS_SWI_SET_HOST_DEV_INFO );
    return eRCode;
}
