/*
 * \ingroup dms
 *
 * \file    qaDmsSLQSSwiSetDyingGaspCfg.c
 *
 * \brief   Contains Packing and UnPacking routines for the
 *          eQMI_DMS_SWI_SET_DYING_GASP_CFG message.
 *
 * Copyright: © 2016 Sierra Wireless, Inc. all rights reserved
 *
 */

/* include files */

#include "SwiDataTypes.h"
#include "qmudefs.h"
#include "qmerrno.h"
#include "sludefs.h"
#include "qaDmsSLQSSwiSetDyingGaspCfg.h"

/******************************************************************************
 * Request handling
 ******************************************************************************/
enum eQCWWANError BuildTlvBuildSMSDestinationNumber( BYTE *pBuf, BYTE *pParam )
{
    setDyingGaspCfg *pReq =
    ((QmiDmsSwiSetDyingGaspCfgReq *)pParam)->pSetDyingGaspCfg;
    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;
    int i = 0;
    int iLength = 0;
    /* Check For Null Parameter */
    if ( NULL == pReq )
    {
        return eRCode;
    }
    else if (NULL ==pReq->pDestSMSNum)
    {
        return eRCode;
    }

    iLength = strlen((char*)pReq->pDestSMSNum);
    if(MAX_DYING_GASP_CFG_SMS_NUMBER_LENGTH<iLength)
    {
        return eQCWWAN_ERR_BUFFER_SZ;
    }
    for ( i = 0; i < iLength; i++)
    {
        eRCode = PutByte( pBuf, pReq->pDestSMSNum[i]);
    }
    
    return eRCode;
}

enum eQCWWANError BuildTlvBuildSMSContent( BYTE *pBuf, BYTE *pParam )
{
    setDyingGaspCfg *pReq =
    ((QmiDmsSwiSetDyingGaspCfgReq *)pParam)->pSetDyingGaspCfg;
    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;
    int i = 0;
    int iLength = 0;

    /* Check For Null Parameter */
    if ( NULL == pReq )
    {
        return eRCode;
    }
    else if (pReq->pDestSMSContent == NULL)
    {
        return eRCode;
    }

    iLength = strlen((char*)pReq->pDestSMSContent);
    if(MAX_DYING_GASP_CFG_SMS_CONTENT_LENGTH<iLength)
    {
        return eQCWWAN_ERR_BUFFER_SZ;
    }
    for ( i = 0; i < iLength; i++)
    {
        eRCode = PutByte( pBuf, pReq->pDestSMSContent[i]);
    }

    return eRCode;
}

/*
 * This function packs the Set Dying GASP Config request parameters to the QMI
 * message SDU
 *
 * \param  pMlength            [OUT] - Total length of built message.
 *
 * \param  pParamField         [OUT] - Pointer to storage into which the packed
 *                                     data will be placed by this function.
 *
 * \param  pCustfeatureSetting [IN]  - structure containing data to be packed.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 * \sa qaGobiApiDms.h for remaining parameter descriptions.
 */
enum eQCWWANError PkQmiDmsSwiSetDyingGaspCfg(
    WORD                *pMlength,
    BYTE                *pParamField,
    setDyingGaspCfg *pSetDyingGaspCfg )
{
    static struct qmTlvBuilderItem map[] =
    {
        { eTLV_DMS_SWI_SET_DYGING_GASP_CFG_SMS_DEST_NO,
            &BuildTlvBuildSMSDestinationNumber },
        { eTLV_DMS_SWI_SET_DYGING_GASP_CFG_SMS_CONTENT,
            &BuildTlvBuildSMSContent },
        { eTLV_TYPE_INVALID,   NULL } /* Important. Sentinel.
                                       * Signifies last item in map
                                       */
    };

    QmiDmsSwiSetDyingGaspCfgReq req;
    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;
    memset(&req, 0, sizeof(QmiDmsSwiSetDyingGaspCfgReq));
    
    req.pSetDyingGaspCfg = pSetDyingGaspCfg;

    eRCode = qmbuild( pParamField,
                      (BYTE *)&req,
                      map,
                      eQMI_DMS_SWI_SET_DYING_GASP_CFG,
                      pMlength );
    return eRCode;
}

/******************************************************************************
 * Response handling
 ******************************************************************************/
/*
 * This function unpacks the Set the Dying GASP Config for the 
 * Dying Gasp feature request parameters to the QMI message SDU
 *
 * \param  pMdmResp - Pointer to packed response from the modem.
 *
 * \param  pApiResp - Pointer to storage to unpack into.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 */
enum eQCWWANError UpkQmiDmsSwiSetDyingGaspCfg(
    BYTE                             *pMdmResp,
    QmiDmsSwiSetDyingGaspCfgResp *pApiResp )
{
    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    static struct qmTlvUnpackerItem map[] =
    {
        { eTLV_RESULT_CODE,  &qmUnpackTlvResultCode },
        { eTLV_TYPE_INVALID, NULL } /* Important. Sentinel.
                                     * Signifies last item in map.
                                     */
    };

    eRCode = qmunpackresp( pMdmResp,
                           (BYTE *)pApiResp,
                           map,
                           eQMI_DMS_SWI_SET_DYING_GASP_CFG );
    return eRCode;
}

