/*
 * \ingroup dms
 *
 * \file    qaDmsSLQSSwiSetCrashAction.c
 *
 * \brief   Contains Packing and UnPacking routines for the
 *          eQMI_DMS_SWI_SET_CRASH_ACTION message.
 *
 * Copyright: © 2014 Sierra Wireless, Inc. all rights reserved
 *
 */

/* include files */
#include "SwiDataTypes.h"
#include "sludefs.h"
#include "qmudefs.h"
#include "qmerrno.h"
#include "qaGobiApiDms.h"
#include "qaDmsSLQSSwiSetCrashAction.h"

/*****************************************************************************
 * Request handling
 *****************************************************************************/

/*
 * This function packs the Dev Crash State request parameters to
 * the QMI message SDU *
 *
 * \param  pBuf   [OUT] - Pointer to storage into which the packed
 *                        data will be placed by this function.
 *
 * \param  pParam [IN]  - Pointer to structure containing data for this TLV.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 */
enum eQCWWANError BuildTlvDevCrashActionState( BYTE *pBuf, BYTE *pParam )
{
    struct QmiDmsSLQSSwiSetCrashActionReq *pDevCrashState =
                     ( struct QmiDmsSLQSSwiSetCrashActionReq *) pParam;

    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    if (( pDevCrashState->crashActionParams ) > 2)
    {
        return eQCWWAN_ERR_INVALID_ARG;
    }

    /* Insert Device crash action */
    eRCode = PutByte( pBuf, pDevCrashState->crashActionParams);

    return eRCode;
}

/*
 * This function packs the SLQSSwiSetCrashAction request parameters to
 * the QMI message SDU
 *
 * \param  pMlength     [OUT] - Total length of built message.
 *
 * \param  pParamField  [OUT] - Pointer to storage into which the packed data
 *                              will be placed by this function.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 */
enum eQCWWANError PkQmiDmsSLQSSwiSetCrashAction(
    WORD *pMlength,
    BYTE *pParamField,
    BYTE crashActionParams)
{
    static struct qmTlvBuilderItem map[] =
    {
        { eTLV_DMS_SET_DEV_CRASH_ACTION_STATE, &BuildTlvDevCrashActionState },
        { eTLV_TYPE_INVALID,                   NULL }/* Important. Sentinel.
                                                      * Signifies last item in map
                                                      */
    };

    struct QmiDmsSLQSSwiSetCrashActionReq req;
    slmemset((CHAR *)&req, 0, sizeof(struct QmiDmsSLQSSwiSetCrashActionReq));
    req.crashActionParams = crashActionParams;

    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    eRCode =  qmbuild( pParamField,
                       (BYTE *)&req,
                       map,
                       eQMI_DMS_SWI_SET_CRASH_ACTION,
                       pMlength );
    return eRCode;
}

/*****************************************************************************
 * Response handling
 *****************************************************************************/

/*
 * This function unpacks the SLQSSwiSetCrashAction response to a
 * user-provided response structure.
 *
 * \param  pMdmResp           - Pointer to packed response from the modem.
 *
 * \param  pApiResp           - Pointer to storage to unpack into.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 */
enum eQCWWANError UpkQmiDmsSLQSSwiSetCrashAction(
    BYTE                                 *pMdmResp,
    struct QmiDmsSLQSSwiSetCrashActionResp *pApiResp )
{
    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    static struct qmTlvUnpackerItem map[] =
    {
        { eTLV_RESULT_CODE,  &qmUnpackTlvResultCode },
        { eTLV_TYPE_INVALID, NULL } /* Important. Sentinel.
                                     * Signifies last item in map.
                                     */
    };

    eRCode = qmunpackresp( pMdmResp,
                           (BYTE *)pApiResp,
                           map,
                           eQMI_DMS_SWI_SET_CRASH_ACTION );
    return eRCode;
}
