/*
 * \ingroup dms
 *
 * \file    qaDmsSLQSSwiGetSerialNoExt.c
 *
 * \brief   Contains Packing and UnPacking routines for the
 *          eQMI_DMS_GET_DEVICE_SERIAL_NUMBERS message.
 *
 * Copyright: © 2015 Sierra Wireless, Inc. all rights reserved
 *
 */

/* include files */
#include "SwiDataTypes.h"
#include "qmudefs.h"
#include "qmerrno.h"
#include "qaGobiApiDms.h"
#include "qaDmsSLQSSwiGetSerialNoExt.h"

/*****************************************************************************
 * Request handling
 *****************************************************************************/
/*
 * This function packs the GetOSInfo request parameters to
 * the QMI message SDU
 *
 * \param  pMlength     [OUT] - Total length of built message.
 *
 * \param  pParamField  [OUT] - Pointer to storage into which the packed data
 *                              will be placed by this function.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 */
enum eQCWWANError PkQmiDmsSLQSSwiGetSerialNoExt(
    WORD *pMlength,
    BYTE *pParamField )
{
    static struct qmTlvBuilderItem map[] =
    {
        { eTLV_TYPE_INVALID, NULL }/* Important. Sentinel.
                                    * Signifies last item in map
                                    */
    };

    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    eRCode =  qmbuild( pParamField,
                       NULL,
                       map,
                       eQMI_DMS_SWI_GET_SERIAL_NO_EXT,
                       pMlength );
    return eRCode;
}

/*****************************************************************************
 * Response handling
 *****************************************************************************/
/*
 * This function unpacks the Device MEID from the QMI response
 * message to a user provided response structure
 *
 * \param pTlvData - Pointer to TLV data from which to unpack.
 *
 * \param pResp    - Pointer to structure containing storage
 *                   to return data for this TLV.
 *
 * \return eQCWWAN_ERR_NONE
 */
enum eQCWWANError UnpackTlvGetDeviceMEID(BYTE *pTlvData, BYTE *pResp)
{
    struct QmiDmsSLQSSwiGetSerialNoExtResp *lResp =
        (struct QmiDmsSLQSSwiGetSerialNoExtResp *)pResp;

    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    /* Check For Null Parameter */
    if ( 0 == lResp->meidLength )
    {
        return eRCode;
    }

    /* Extract the String Parameter */
    /* The size of the string is stored to check for buffer size in API */
    eRCode = qmQmiExtractString( pTlvData,
                                 lResp->pMeidString,
                                 lResp->meidLength );
	return eRCode;
}


/*
 * This function unpacks the SLQSSwiGetOSInfo response to a
 * user-provided response structure.
 *
 * \param  pMdmResp           - Pointer to packed response from the modem.
 *
 * \param  pApiResp           - Pointer to storage to unpack into.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 */
enum eQCWWANError UpkQmiDmsSLQSSwiGetSerialNoExt(
    BYTE                                   *pMdmResp,
    struct QmiDmsSLQSSwiGetSerialNoExtResp *pApiResp )
{
    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    static struct qmTlvUnpackerItem map[] =
    {
        { eTLV_RESULT_CODE,                 &qmUnpackTlvResultCode },
        { eTLV_DMS_GET_DEV_MEID,            &UnpackTlvGetDeviceMEID },
        { eTLV_TYPE_INVALID,                NULL } /* Important. Sentinel.
                                             * Signifies last item in map.
                                             */
    };

    eRCode = qmunpackresp( pMdmResp,
                           (BYTE *)pApiResp,
                           map,
                           eQMI_DMS_SWI_GET_OS_INFO );
    return eRCode;
}
