/*
 * \ingroup dms
 *
 * \file    qaDmsSLQSSwiClearDyingGaspStatistics.c
 *
 * \brief   Contains Packing and UnPacking routines for the
 *          eQMI_DMS_SWI_CLR_DYING_GASP_STAT message.
 *
 * Copyright: © 2016 Sierra Wireless, Inc. all rights reserved
 *
 */

/* include files */

#include "SwiDataTypes.h"
#include "qmudefs.h"
#include "qmerrno.h"
#include "sludefs.h"
#include "qaDmsSLQSSwiClearDyingGaspStatistics.h"

/*
 * This function packs the Clear Statistics for the 
 * Dying Gasp feature request parameters to the QMI message SDU
 *
 * \param  pMlength            [OUT] - Total length of built message.
 *
 * \param  pParamField         [OUT] - Pointer to storage into which the packed
 *                                     data will be placed by this function.
 *
 * \param  pCustfeatureSetting [IN]  - structure containing data to be packed.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 * \sa qaGobiApiDms.h for remaining parameter descriptions.
 */
enum eQCWWANError PkQmiDmsSwiClearDyingGaspStatistics(
    WORD                *pMlength,
    BYTE                *pParamField )
{
    static struct qmTlvBuilderItem map[] =
    {
        { eTLV_TYPE_INVALID,   NULL } /* Important. Sentinel.
                                       * Signifies last item in map
                                       */
    };
    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;
    eRCode = qmbuild( pParamField,
                      NULL,
                      map,
                      eQMI_DMS_SWI_CLR_DYING_GASP_STAT,
                      pMlength );
    return eRCode;
}

/******************************************************************************
 * Response handling
 ******************************************************************************/
/*
 * This function unpacks the Clear Statistics for the 
 * Dying Gasp feature request parameters to the QMI message SDU
 *
 * \param  pMdmResp - Pointer to packed response from the modem.
 *
 * \param  pApiResp - Pointer to storage to unpack into.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 */
enum eQCWWANError UpkQmiDmsSwiClearDyingGaspStatistics(
    BYTE                             *pMdmResp,
    QmiDmsSwiClearDyingGaspStatisticsResp *pApiResp )
{
    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    static struct qmTlvUnpackerItem map[] =
    {
        { eTLV_RESULT_CODE,  &qmUnpackTlvResultCode },
        { eTLV_TYPE_INVALID, NULL } /* Important. Sentinel.
                                     * Signifies last item in map.
                                     */
    };

    eRCode = qmunpackresp( pMdmResp,
                           (BYTE *)pApiResp,
                           map,
                           eQMI_DMS_SWI_CLR_DYING_GASP_STAT );
    return eRCode;
}

