/*
 * \ingroup dms
 *
 * \file    qaDmsSLQSSetCustFeaturesV2.c
 *
 * \brief   Contains Packing and UnPacking routines for the
 *          QMI_DMS_SWI_SET_CUST_FEATURES message.
 *
 * Copyright: © 2015 Sierra Wireless, Inc. all rights reserved
 *
 */

/* include files */

#include "SwiDataTypes.h"
#include "qmudefs.h"
#include "qmerrno.h"
#include "sludefs.h"
#include "qaDmsSLQSSetCustFeaturesV2.h"

/******************************************************************************
 * Request handling
 ******************************************************************************/
enum eQCWWANError BuildTlvCustSetting( BYTE *pBuf, BYTE *pParam )
{
    setCustomSettingV2 *pReq =
    ((struct QmiDmsSetCustFeaturesV2Req *)pParam)->pSetCustSetting;
    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;
    BYTE i;

    /* Check For Null Parameter */
    if ( NULL == pReq )
    {
        return eRCode;
    }

    eRCode = PutWord( pBuf, strlen(pReq->cust_id) );
    CHECK();
    for ( i = 0; i < strlen(pReq->cust_id); i++)
    {
        eRCode = PutByte( pBuf, pReq->cust_id[i]);
        CHECK();
    }

    eRCode = PutWord( pBuf, pReq->value_length );
    CHECK();
    for ( i = 0; i < pReq->value_length; i++)
    {
        eRCode = PutByte( pBuf, pReq->cust_value[i]);
    }

    return eRCode;
}

/*
 * This function packs the Set Custom Features Version 2 request parameters to the QMI
 * message SDU
 *
 * \param  pMlength            [OUT] - Total length of built message.
 *
 * \param  pParamField         [OUT] - Pointer to storage into which the packed
 *                                     data will be placed by this function.
 *
 * \param  pCustfeatureSetting [IN]  - structure containing data to be packed.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 * \sa qaGobiApiDms.h for remaining parameter descriptions.
 */
enum eQCWWANError PkQmiDmsSetCustFeaturesV2(
    WORD                *pMlength,
    BYTE                *pParamField,
    setCustomSettingV2 *pSetCustSetting )
{
    static struct qmTlvBuilderItem map[] =
    {
        { eTLV_CUST_SETTING,   &BuildTlvCustSetting },
        { eTLV_TYPE_INVALID,   NULL } /* Important. Sentinel.
                                       * Signifies last item in map
                                       */
    };

    struct QmiDmsSetCustFeaturesV2Req req;
    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    slmemset((CHAR *)&req, 0, sizeof(struct QmiDmsSetCustFeaturesV2Req));
    req.pSetCustSetting = pSetCustSetting;

    eRCode = qmbuild( pParamField,
                      (BYTE *)&req,
                      map,
                      eQMI_DMS_SWI_SET_CUST_FEATURES,
                      pMlength );
    return eRCode;
}

/******************************************************************************
 * Response handling
 ******************************************************************************/
/*
 * This function unpacks the set custom features Version 2 response message to a user
 * provided response structure.
 *
 * \param  pMdmResp - Pointer to packed response from the modem.
 *
 * \param  pApiResp - Pointer to storage to unpack into.
 *
 * \return eQCWWAN_ERR_NONE, on success, eQCWWAN_ERR_XXX otherwise
 *
 */
enum eQCWWANError UpkQmiDmsSetCustFeaturesV2(
    BYTE                             *pMdmResp,
    struct QmiDmsSetCustFeaturesV2Resp *pApiResp )
{
    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    static struct qmTlvUnpackerItem map[] =
    {
        { eTLV_RESULT_CODE,  &qmUnpackTlvResultCode },
        { eTLV_TYPE_INVALID, NULL } /* Important. Sentinel.
                                     * Signifies last item in map.
                                     */
    };

    eRCode = qmunpackresp( pMdmResp,
                           (BYTE *)pApiResp,
                           map,
                           eQMI_DMS_SWI_SET_CUST_FEATURES );
    return eRCode;
}
