/*
 * \ingroup dms
 *
 * \file qaDmsSwiGetResetInfor.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaDmsSwiGetResetInfor.c
 *
 * Copyright: © 2016 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __DMS_SWI_SWI_GET_RESET_INFO_H__
#define __DMS_SWI_SWI_GET_RESET_INFO_H__

#include "qaGobiApiDms.h"

/*
 *
 * An enumeration of eQMI_DMS_SWI_GET_RESET_INFO response TLV IDs
 *
 */
enum eQMI_DMS_SWI_GET_RESET_INFO_RESP
{
    eTLV_DMS_SWI_GET_RESET_INFO    = 0x01,
};

/*
 * This structure contains the SWI Get Reset Info parameters.
 *
 * \sa qaGobiApiDms.h for parameter descriptions
 *
 */
struct QmiDmsSwiGetResetInfoResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;
    dmsSwiGetResetInfo *pResetInfo;
};

/************
 * Prototypes
 **************/
extern enum eQCWWANError PkQmiDmsSwiGetResetInfo (
    WORD    *pMlength,
    BYTE    *pParamField );

extern enum eQCWWANError UpkQmiDmsSwiGetResetInfo (
    BYTE     *pMdmResp,
    struct   QmiDmsSwiGetResetInfoResp *pAipResp );

#endif /* __DMS_SWI_SWI_GET_RESET_INFO_H__ */

/*
 * \ingroup dms
 *
 * \file qaDmsSwiGetResetInfor.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaDmsSwiGetResetInfor.c
 *
 * Copyright: © 2016 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __DMS_SWI_SWI_GET_RESET_INFO_H__
#define __DMS_SWI_SWI_GET_RESET_INFO_H__

#include "qaGobiApiDms.h"

/*
 *
 * An enumeration of eQMI_DMS_SWI_GET_RESET_INFO response TLV IDs
 *
 */
enum eQMI_DMS_SWI_GET_RESET_INFO_RESP
{
    eTLV_DMS_SWI_GET_RESET_INFO    = 0x01,
};

/*
 * This structure contains the SWI Get Reset Info parameters.
 *
 * \sa qaGobiApiDms.h for parameter descriptions
 *
 */
struct QmiDmsSwiGetResetInfoResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;
    dmsSwiGetResetInfo *pResetInfo;
};

/************
 * Prototypes
 **************/
extern enum eQCWWANError PkQmiDmsSwiGetResetInfo (
    WORD    *pMlength,
    BYTE    *pParamField );

extern enum eQCWWANError UpkQmiDmsSwiGetResetInfo (
    BYTE     *pMdmResp,
    struct   QmiDmsSwiGetResetInfoResp *pAipResp );

#endif /* __DMS_SWI_SWI_GET_RESET_INFO_H__ */

