/*
 * \ingroup dms
 *
 * \file  qaDmsSLQSSwiSetUSBComp.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaDmsSLQSSwiSetUSBComp.c
 *
 * Copyright: © 2014 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __DMS_SLQS_SWI_SET_USB_COMP_H__
#define __DMS_SLQS_SWI_SET_USB_COMP_H__

/* enum declarations */
/*
 *
 * An enumeration of eQMI_DMS_SLQS_SWI_SET_USB_COMP response TLV IDs
 *
 */
enum eDMS_SLQS_SWI_SET_USB_COMP_RESP
{
    eTLV_DMS_SET_USB_COMP = 0x01,
};

/*
 * This structure contains the SLQSSwiSetUSBComp response parameters.
 *
 * \sa qaGobiApiDms.h for parameter descriptions
 *
 */
struct QmiDmsSLQSSwiSetUSBCompResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;
};

/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiDmsSLQSSwiSetUSBComp (
    WORD          *pMlength,
    BYTE          *pParamField,
    USBCompConfig *pUSBCompConfig );

extern enum eQCWWANError UpkQmiDmsSLQSSwiSetUSBComp (
    BYTE                               *pMdmResp,
    struct QmiDmsSLQSSwiSetUSBCompResp *pApiResp );

#endif /* __DMS_SLQS_SWI_SET_USB_COMP_H__ */
