/*
 * \ingroup dms
 *
 * \file  qaDmsSLQSSwiSetOSInfo.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaDmsSLQSSwiGetFwUpdatStat.c
 *
 * Copyright: Â© 2014 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __DMS_SLQS_SWI_SET_OS_INFO_H__
#define __DMS_SLQS_SWI_SET_OS_INFO_H__


/* enum declarations */
/*
 *
 * An enumeration of eQMI_DMS_SLQS_SWI_SET_OS_INFO response TLV IDs
 *
 */
enum eDMS_SLQS_SWI_SET_OS_INFO_REQ
{
    eTLV_DMS_SET_OS_INFO_NAME    = 0x10,
    eTLV_DMS_SET_OS_INFO_VERSION = 0x11,

};

/*
 * This structure contains the SLQSSwiGetFwUpdateStatus response parameters.
 *
 * \sa qaGobiApiDms.h for parameter descriptions
 *
 */
struct QmiDmsSLQSSwiSetOSInfoResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;
};

struct QmiDmsSLQSSwiSetOSInfoReq
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;
    BYTE bNameSize;
	CHAR *pNameString;
	BYTE bVersionSize;
	CHAR *pVersionString;

};


/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiDmsSLQSSwiSetOSInfo (
    WORD *pMlength,
    BYTE *pParamField, 
    struct QmiDmsSLQSSwiSetOSInfoReq *pApiReq);

extern enum eQCWWANError UpkQmiDmsSLQSSwiSetOSInfo (
    BYTE                                 *pMdmResp,
    struct QmiDmsSLQSSwiSetOSInfoResp *pApiResp );

#endif /* __DMS_SLQS_SWI_SET_OS_INFO_H__ */
