/*
 * \ingroup dms
 *
 * \file  qaDmsSLQSSwiSetHostDevInfo.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaDmsSLQSSwiGetFwUpdatStat.c
 *
 * Copyright: © 2014 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __DMS_SLQS_SWI_SET_HOST_DEV_INFO_H__
#define __DMS_SLQS_SWI_SET_HOST_DEV_INFO_H__

/* enum declarations */
/*
 *
 * An enumeration of eQMI_DMS_SLQS_SWI_SET_HOST_DEV_INFO response TLV IDs
 *
 */
enum eDMS_SLQS_SWI_SET_HOST_DEV_INFO_REQ
{
    eTLV_DMS_SET_HOST_DEV_INFO_MANUFACTURER = 0x10,
    eTLV_DMS_SET_HOST_DEV_INFO_MODEL = 0x11,
    eTLV_DMS_SET_HOST_DEV_INFO_SOFTWARE_VERSION = 0x12,
    eTLV_DMS_SET_HOST_DEV_INFO_PLASMA_ID = 0x13,
};

/*
 * This structure contains the SLQSSwiGetFwUpdateStatus response parameters.
 *
 * \sa qaGobiApiDms.h for parameter descriptions
 *
 */
struct QmiDmsSLQSSwiSetHostDevInfoResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;
};

struct QmiDmsSLQSSwiSetHostDevInfoReq
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;
	BYTE bManSize;
	CHAR *pManString;
	BYTE bModelSize;
	CHAR *pModelString;
	BYTE bSWVerSize;
	CHAR *pSWVerString;
	BYTE bPlasmaIDSize;
	CHAR *pPlasmaIDString;
};


/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiDmsSLQSSwiSetHostDevInfo (
    WORD *pMlength,
    BYTE *pParamField, 
    struct QmiDmsSLQSSwiSetHostDevInfoReq *pApiReq);

extern enum eQCWWANError UpkQmiDmsSLQSSwiSetHostDevInfo (
    BYTE                                 *pMdmResp,
    struct QmiDmsSLQSSwiSetHostDevInfoResp *pApiResp );

#endif /* __DMS_SLQS_SWI_SET_HOST_DEV_INFO_H__ */
