/*
 * \ingroup dms
 *
 * \file    qaDmsSLQSSwiSetDyingGaspCfg.h
 *
 * \brief   This file contains definitions, enumerations, structures and
 *          forward declarations for qaDmsSLQSSetDyingGaspCfg.c
 *
 * Copyright: © 2016 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __DMS_SWI_SET_DYING_GASP_CFG_H__
#define __DMS_SWI_SET_DYING_GASP_CFG_H__

#include "qaGobiApiDms.h"

/* enum declarations */

/*
 * An enumeration of eQMI_DMS_SWI_SET_DYING_GASP_CFG request TLV IDs
 */
enum eQMI_DMS_SWI_SET_DYING_GASP_CFG_REQ
{
    eTLV_DMS_SWI_SET_DYGING_GASP_CFG_SMS_DEST_NO   = 0x10,
    eTLV_DMS_SWI_SET_DYGING_GASP_CFG_SMS_CONTENT   = 0x11,
};

/*
 * This structure contains the Dying Gasp request parameters.
 */
typedef struct
{
    setDyingGaspCfg *pSetDyingGaspCfg;
}QmiDmsSwiSetDyingGaspCfgReq;

/*
 * This structure contains the Dying Gasp response parameters.
 */
typedef struct
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;
}QmiDmsSwiSetDyingGaspCfgResp;

/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiDmsSwiSetDyingGaspCfg(
    WORD                *pMlength,
    BYTE                *pParamField,
    setDyingGaspCfg *pSetCustSetting );

extern enum eQCWWANError UpkQmiDmsSwiSetDyingGaspCfg(
    BYTE                             *pMdmResp,
    QmiDmsSwiSetDyingGaspCfgResp *pApiResp );

#endif /* __DMS_SWI_SET_DYING_GASP_CFG_H__ */
