/*
 * \ingroup dms
 *
 * \file  qaDmsSLQSSwiSetCrashAction.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaDmsSLQSSwiSetCrashAction.c
 *
 * Copyright: © 2014 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __DMS_SLQS_SWI_SET_CRASH_ACTION_H__
#define __DMS_SLQS_SWI_SET_CRASH_ACTION_H__

/* enum declarations */
/*
 *
 * An enumeration of eQMI_DMS_SLQS_SWI_SET_CRASH_ACTION request TLV IDs
 *
 */
enum eDMS_SLQS_SWI_SET_CRASH_ACTION_REQ
{
    eTLV_DMS_SET_DEV_CRASH_ACTION_STATE = 0x01
};

/*
 * This structure contains the SLQSSwiSetCrashAction request parameters.
 *
 * \sa qaGobiApiDms.h for parameter descriptions
 *
 */
struct QmiDmsSLQSSwiSetCrashActionReq
{
    BYTE crashActionParams;
};

/*
 * This structure contains the SLQSSwiSetCrashAction response parameters.
 *
 * see qaGobiApiDms.h for parameter descriptions
 *
 */
struct QmiDmsSLQSSwiSetCrashActionResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;
};

/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiDmsSLQSSwiSetCrashAction(
    WORD              *pMlength,
    BYTE              *pParamField,
    BYTE              crashActionParams);

extern enum eQCWWANError UpkQmiDmsSLQSSwiSetCrashAction (
    BYTE                                   *pMdmResp,
    struct QmiDmsSLQSSwiSetCrashActionResp *pApiResp );

#endif /* __DMS_SLQS_SWI_SET_CRASH_ACTION_H__ */
