/*
 * \ingroup dms
 *
 * \file  qaDmsSLQSSwiGetUSBComp.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaDmsSLQSSwiGetUSBComp.c
 *
 * Copyright: © 2014 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __DMS_SLQS_SWI_GET_USB_COMP_H__
#define __DMS_SLQS_SWI_GET_USB_COMP_H__

/* enum declarations */
/*
 *
 * An enumeration of eQMI_DMS_SLQS_SWI_GET_USB_COMP response TLV IDs
 *
 */
enum eDMS_SLQS_SWI_GET_USB_COMP_RESP
{
    eTLV_DMS_GET_USB_COMP      = 0x10,
    eTLV_DMS_GET_SUPP_USB_COMP = 0x11,
};

/*
 * This structure contains the SLQSSwiGetUSBComp response parameters.
 *
 * \sa qaGobiApiDms.h for parameter descriptions
 *
 */
struct QmiDmsSLQSSwiGetUSBCompResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;

    USBCompParams *pUSBCompParams;
};

/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiDmsSLQSSwiGetUSBComp (
    WORD *pMlength,
    BYTE *pParamField );

extern enum eQCWWANError UpkQmiDmsSLQSSwiGetUSBComp (
    BYTE                               *pMdmResp,
    struct QmiDmsSLQSSwiGetUSBCompResp *pApiResp );

#endif /* __DMS_SLQS_SWI_GET_USB_COMP_H__ */
