/*
 * \ingroup dms
 *
 * \file  qaDmsSLQSSwiGetSerialNoExt.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaDmsSLQSSwiGetSerialNoExt.c
 *
 * Copyright: © 2015 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __DMS_SLQS_SWI_GET_SERIAL_NO_EXT_H__
#define __DMS_SLQS_SWI_GET_SERIAL_NO_EXT_H__


/* enum declarations */
/*
 *
 * An enumeration of eQMI_DMS_GET_DEVICE_SERIAL_NUMBERS response TLV IDs
 *
 */
enum eDMS_SLQS_SWI_GET_SERIAL_NO_RESP
{
    eTLV_DMS_GET_DEV_MEID     = 0x10,
};

/*
 * This structure contains the SLQSSwiGetSerialNoExt response parameters.
 *
 * \sa qaGobiApiDms.h for parameter descriptions
 *
 */
struct QmiDmsSLQSSwiGetSerialNoExtResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;

    BYTE     meidLength;
    CHAR    *pMeidString;
};

/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiDmsSLQSSwiGetSerialNoExt (
    WORD *pMlength,
    BYTE *pParamField );

extern enum eQCWWANError UpkQmiDmsSLQSSwiGetSerialNoExt (
    BYTE                                   *pMdmResp,
    struct QmiDmsSLQSSwiGetSerialNoExtResp *pApiResp );

#endif /* __DMS_SLQS_SWI_GET_SERIAL_NO_EXT_H__ */

