/*
 * \ingroup dms
 *
 * \file  qaDmsSLQSSwiGetOSInfo.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaDmsSLQSSwiGetOSInfo.c
 *
 * Copyright: © 2014 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __DMS_SLQS_SWI_GET_OS_INFO_H__
#define __DMS_SLQS_SWI_GET_OS_INFO_H__


/* enum declarations */
/*
 *
 * An enumeration of eQMI_DMS_SLQS_SWI_GET_OS_INFO response TLV IDs
 *
 */
enum eDMS_SLQS_SWI_GET_OS_INFO_RESP
{
    eTLV_DMS_GET_OS_INFO_NAME     	= 0x10,
    eTLV_DMS_GET_OS_INFO_VERSION   	= 0x11,
};

/*
 * This structure contains the SLQSSwiGetOSInfo response parameters.
 *
 * \sa qaGobiApiDms.h for parameter descriptions
 *
 */
struct QmiDmsSLQSSwiGetOSInfoResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;

    BYTE bNameSize;
	CHAR *pNameString;
	BYTE bVersionSize;
	CHAR *pVersionString;
};

/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiDmsSLQSSwiGetOSInfo (
    WORD *pMlength,
    BYTE *pParamField );

extern enum eQCWWANError UpkQmiDmsSLQSSwiGetOSInfo (
    BYTE                               *pMdmResp,
    struct QmiDmsSLQSSwiGetOSInfoResp *pApiResp );

#endif /* __DMS_SLQS_SWI_GET_OS_INFO_H__ */

