/*
 * \ingroup dms
 *
 * \file  qaDmsSLQSSwiGetHostDevInfo.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaDmsSLQSSwiGetHostDevInfo.c
 *
 * Copyright: Â© 2014 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __DMS_SLQS_SWI_GET_HOST_DEV_INFO_H__
#define __DMS_SLQS_SWI_GET_HOST_DEV_INFO_H__


/* enum declarations */
/*
 *
 * An enumeration of eQMI_DMS_SLQS_SWI_GET_HOST_DEV_INFO response TLV IDs
 *
 */
enum eDMS_SLQS_SWI_GET_HOST_DEV_INFO_RESP
{
    eTLV_DMS_GET_HOST_DEV_INFO_MANUFACTURER     	= 0x10,
	eTLV_DMS_GET_HOST_DEV_INFO_MODEL            	= 0x11,
	eTLV_DMS_GET_HOST_DEV_INFO_SOFTWARE_VERSION 	= 0x12,
	eTLV_DMS_GET_HOST_DEV_INFO_PLASMA_ID			= 0x13,
};

/*
 * This structure contains the SLQSSwiGetHostDevInfo response parameters.
 *
 * \sa qaGobiApiDms.h for parameter descriptions
 *
 */
struct QmiDmsSLQSSwiGetHostDevInfoResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;

    BYTE bManSize;
	CHAR *pManString;
	BYTE bModelSize;
	CHAR *pModelString;
	BYTE bSWVerSize;
	CHAR *pSWVerString;
	BYTE bPlasmaIDSize;
	CHAR *pPlasmaIDString;
};

/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiDmsSLQSSwiGetHostDevInfo (
    WORD *pMlength,
    BYTE *pParamField );

extern enum eQCWWANError UpkQmiDmsSLQSSwiGetHostDevInfo (
    BYTE                               *pMdmResp,
    struct QmiDmsSLQSSwiGetHostDevInfoResp *pApiResp );

#endif /* __DMS_SLQS_SWI_GET_HOST_DEV_INFO_H__ */
