/*
 * \ingroup dms
 *
 * \file  qaDmsSLQSSwiGetFwUpdatStat.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaDmsSLQSSwiGetFwUpdatStat.c
 *
 * Copyright: © 2014 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __DMS_SLQS_SWI_GET_FW_UPDAT_STAT_H__
#define __DMS_SLQS_SWI_GET_FW_UPDAT_STAT_H__

#define DMS_SLQS_SWI_MAX_LOG_STRING_SIZE 256
/* enum declarations */
/*
 *
 * An enumeration of eQMI_DMS_SLQS_SWI_GET_FW_UPDATE_STAT response TLV IDs
 *
 */
enum eDMS_SLQS_SWI_GET_FW_UPDAT_STAT_RESP
{
    eTLV_DMS_FWUPD_RES_CODE = 0x10,
    eTLV_DMS_FWUPD_IMG_TYPE = 0x11,
    eTLV_DMS_FWUPD_REF_DATA = 0x12,
    eTLV_DMS_FWUPD_REF_STRING = 0x13,
    eTLV_DMS_FWUPD_LOG_STRING = 0x14,
};

/*
 * This structure contains the SLQSSwiGetFwUpdateStatus response parameters.
 *
 * \sa qaGobiApiDms.h for parameter descriptions
 *
 */
struct QmiDmsSLQSSwiGetFwUpdStatResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;

    FirmwareUpdatStat  *pFirmwareUpdatStat;
};

/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiDmsSLQSSwiGetFwUpdStat (
    WORD *pMlength,
    BYTE *pParamField );

extern enum eQCWWANError UpkQmiDmsSLQSSwiGetFwUpdStat (
    BYTE                                 *pMdmResp,
    struct QmiDmsSLQSSwiGetFwUpdStatResp *pApiResp );

#endif /* __DMS_SLQS_SWI_GET_FW_UPDAT_STAT_H__ */
