/*
 * \ingroup dms
 *
 * \file    qaDmsSLQSSwiGetDyingGaspStatistics.h
 *
 * \brief   This file contains definitions, enumerations, structures and
 *          forward declarations for qaDmsSLQSSwiGetDyingGaspStatistics.c
 *
 * Copyright: © 2016 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __DMS_SWI_GET_DYING_GASP_STATATICS_H__
#define __DMS_SWI_GET_DYING_GASP_STATATICS_H__

#include "qaGobiApiDms.h"

/* enum declarations */

/*
 * An enumeration of eQMI_DMS_SWI_GET_DYING_GASP_STAT request TLV IDs
 */
enum eQMI_DMS_SWI_GET_DYING_GASP_STATATICS_RESP
{
    eQMI_DMS_SWI_GET_DYING_GASP_STATATICS_TIMESTAMP   = 0x10,
    eQMI_DMS_SWI_GET_DYING_GASP_STATATICS_SMS_ATTEMPTED_COUNT   = 0x11,
};

/*
 * This structure contains the Dying Gasp Configure response parameters.
 */
typedef struct 
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;
    getDyingGaspStatistics *pDyingGaspstatistics;
}QmiDmsSwiGetDyingGaspStatisticsResp;

/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiDmsSwiGetDyingGaspStatistics(
    WORD                *pMlength,
    BYTE                *pParamField );

extern enum eQCWWANError UpkQmiDmsSwiGetDyingGaspStatistics(
    BYTE                             *pMdmResp,
    QmiDmsSwiGetDyingGaspStatisticsResp *pApiResp );

#endif /* __DMS_SWI_GET_DYING_GASP_STATATICS_H__ */
