/*
 * \ingroup dms
 *
 * \file    qaDmsSLQSSwiGetDyingGaspCfg.h
 *
 * \brief   This file contains definitions, enumerations, structures and
 *          forward declarations for qaDmsSLQSGetDyingGaspCfg.c
 *
 * Copyright: © 2016 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __DMS_SWI_GET_DYING_GASP_CFG_H__
#define __DMS_SWI_GET_DYING_GASP_CFG_H__

#include "qaGobiApiDms.h"

/* enum declarations */

/*
 * An enumeration of eQMI_DMS_SWI_GET_DYING_GASP_CFG request TLV IDs
 */
enum eQMI_DMS_SWI_GET_DYING_GASP_CFG_RESP
{
    eQMI_DMS_SWI_GET_DYING_GASP_CFG_SMS_DEST_NUM_RESP   = 0x10,
    eQMI_DMS_SWI_GET_DYING_GASP_CFG_SMS_DEST_CONTENT_RESP   = 0x11,
};

/*
 * This structure contains the Dying Gasp Configure response parameters.
 */
typedef struct 
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;
    getDyingGaspCfg *pDyingGaspCfg;
}QmiDmsSwiGetDyingGaspCfgResp;

/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiDmsSwiGetDyingGaspCfg(
    WORD                *pMlength,
    BYTE                *pParamField );

extern enum eQCWWANError UpkQmiDmsSwiGetDyingGaspCfg(
    BYTE                             *pMdmResp,
    QmiDmsSwiGetDyingGaspCfgResp *pApiResp );

#endif /* __DMS_SWI_GET_DYING_GASP_CFG_H__ */
