/*
 * \ingroup dms
 *
 * \file  qaDmsSLQSSwiGetCrashInfo.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaDmsSLQSSwiGetCrashInfo.c
 *
 * Copyright: © 2014 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __DMS_SLQS_SWI_GET_CRASH_INFO_H__
#define __DMS_SLQS_SWI_GET_CRASH_INFO_H__

/* Maximum length of the string */
#define MAX_STRING_LEN 65536
#define STR_LEN_ZERO 0

/* enum declarations */
/*
 *
 * An enumeration of eQMI_DMS_SLQS_SWI_GET_CRASH_INFO request TLV IDs
 *
 */
enum eDMS_SLQS_SWI_GET_CRASH_INFO_REQ
{
    eTLV_DMS_CLEAR = 0x10,
};

/* enum declarations */
/*
 *
 * An enumeration of eQMI_DMS_SLQS_SWI_GET_CRASH_INFO response TLV IDs
 *
 */
enum eDMS_SLQS_SWI_GET_CRASH_INFO_RESP
{
    eTLV_DMS_GET_DEV_CRASH_STATUS = 0x01,
    eTLV_DMS_GET_CRASH_INFO       = 0x10,
};

/*
 * This structure contains the SLQSSwiGetCrashInfo request parameters.
 *
 * \sa qaGobiApiDms.h for parameter descriptions
 *
 */
struct QmiDmsSLQSSwiGetCrashInfoReq
{
    /* Every response message must have a results structure */
    BYTE *pClear;
};

/*
 * This structure contains the SLQSSwiGetCrashInfo response parameters.
 *
 * \sa qaGobiApiDms.h for parameter descriptions
 *
 */
struct QmiDmsSLQSSwiGetCrashInfoResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;
    CrashInfoParams    *pCrashInfoParams;
};

/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiDmsSLQSSwiGetCrashInfo (
    WORD *pMlength,
    BYTE *pParamField,
    BYTE *pClear);

extern enum eQCWWANError UpkQmiDmsSLQSSwiGetCrashInfo (
    BYTE                                 *pMdmResp,
    struct QmiDmsSLQSSwiGetCrashInfoResp *pApiResp );

#endif /* __DMS_SLQS_SWI_GET_CRASH_INFO_H__ */
