/*
 * \ingroup dms
 *
 * \file  qaDmsSLQSSwiGetCrashAction.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaDmsSLQSSwiGetCrashAction.c
 *
 * Copyright: © 2014 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __DMS_SLQS_SWI_GET_CRASH_ACTION_H__
#define __DMS_SLQS_SWI_GET_CRASH_ACTION_H__

/* enum declarations */
/*
 *
 * An enumeration of eQMI_DMS_SLQS_SWI_GET_CRASH_ACTION response TLV IDs
 *
 */
enum eDMS_SLQS_SWI_GET_CRASH_ACTION_RESP
{
    eTLV_DMS_GET_DEV_CRASH_ACTION_STATUS = 0x01
};

/*
 * This structure contains the SLQSSwiGetCrashAction response parameters.
 *
 * see qaGobiApiDms.h for parameter descriptions
 *
 */
struct QmiDmsSLQSSwiGetCrashActionResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult  results;
    BYTE                *pDevCrashState;
};

/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiDmsSLQSSwiGetCrashAction (
    WORD *pMlength,
    BYTE *pParamField );

extern enum eQCWWANError UpkQmiDmsSLQSSwiGetCrashAction (
    BYTE                                   *pMdmResp,
    struct QmiDmsSLQSSwiGetCrashActionResp *pApiResp );

#endif /* __DMS_SLQS_SWI_GET_CRASH_ACTION_H__ */
