/*
 * \ingroup dms
 *
 * \file    qaDmsSLQSSwiClearDyingGaspStatistics.h
 *
 * \brief   This file contains definitions, enumerations, structures and
 *          forward declarations for qaDmsSLQSSwiClearDyingGaspStatistics.c
 *
 * Copyright: © 2016 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __DMS_SWI_CLEAR_DYING_GASP_STATISTICS_H__
#define __DMS_SWI_CLEAR_DYING_GASP_STATISTICS_H__

#include "qaGobiApiDms.h"

/*
 * This structure contains the Dying Gasp Configure response parameters.
 */
typedef struct 
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;
}QmiDmsSwiClearDyingGaspStatisticsResp;

/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiDmsSwiClearDyingGaspStatistics(
    WORD                *pMlength,
    BYTE                *pParamField );

extern enum eQCWWANError UpkQmiDmsSwiClearDyingGaspStatistics(
    BYTE                             *pMdmResp,
    QmiDmsSwiClearDyingGaspStatisticsResp *pApiResp );

#endif /* __DMS_SWI_CLEAR_DYING_GASP_STATISTICS_H__ */
