/*
 * \ingroup dms
 *
 * \file    qaDmsSLQSSetCustFeatures.h
 *
 * \brief   This file contains definitions, enumerations, structures and
 *          forward declarations for qaDmsSLQSSetCustFeatures.c
 *
 * Copyright: © 2012 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __DMS_SET_CUST_FEATURES_V2_H__
#define __DMS_SET_CUST_FEATURES_V2_H__

#include "qaGobiApiDms.h"

#define CHECK() \
    if (eRCode!=eQCWWAN_ERR_NONE) return eRCode;
/* enum declarations */

/*
 * An enumeration of eQMI_DMS_SWI_SET_CUST_FEATURES request TLV IDs
 */
enum eQMI_DMS_SWI_SET_CUST_FEATURES_V2_REQ
{
    eTLV_CUST_SETTING   = 0x20
};

/*
 * This structure contains the SetCustFeatures request parameters.
 */
struct QmiDmsSetCustFeaturesV2Req
{
    setCustomSettingV2 *pSetCustSetting;
};

/*
 * This structure contains the SetCustFeatures response parameters.
 */
struct QmiDmsSetCustFeaturesV2Resp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;
};

/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiDmsSetCustFeaturesV2(
    WORD                *pMlength,
    BYTE                *pParamField,
    setCustomSettingV2 *pSetCustSetting );

extern enum eQCWWANError UpkQmiDmsSetCustFeaturesV2(
    BYTE                             *pMdmResp,
    struct QmiDmsSetCustFeaturesV2Resp *pApiResp );

#endif /* __DMS_SET_CUST_FEATURES_V2_H__ */
