/*
 * \ingroup dms
 *
 * \file    qaDmsSLQSGetCustFeaturesV2.h
 *
 * \brief   This file contains definitions, enumerations, structures and
 *          forward declarations for qaDmsSLQSGetCustFeaturesV2.c
 *
 * Copyright: © 2015 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __DMS_GET_CUST_FEATURES_V2_H__
#define __DMS_GET_CUST_FEATURES_V2_H__

#include "qaGobiApiDms.h"

#define CHECK() \
    if (eRCode!=eQCWWAN_ERR_NONE) return eRCode;

/*
 * An enumeration of eQMI_DMS_SWI_GET_CUST_FEATURES request TLV IDs
 */
enum eQMI_DMS_SWI_GET_CUST_FEATURES_V2_REQ
{
    eTLV_CUST_ID_REQ = 0x10,
    eTLV_CUST_LIST_TYPE_REQ = 0x11,
};

/*
 * An enumeration of eQMI_DMS_SWI_GET_CUST_FEATURES response TLV IDs
 */
enum eQMI_DMS_SWI_GET_CUST_FEATURES_V2_RESP
{
    eTLV_CUST_SETTING_INFO = 0x20,
    eTLV_CUST_LIST         = 0x21,
};

/*
 * This structure contains the GetCustFeatures request parameters.
 */
struct QmiDmsGetCustFeaturesV2Req
{
    getCustomInput *pCustSettInput;
};

/*
 * This structure contains the GetCustFeatures response parameters.
 */
struct QmiDmsGetCustFeaturesV2Resp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;

    getCustomFeatureV2 *pGetCustomFeatureV2;
};

/*
 * Prototypes
 */
extern enum eQCWWANError PkQmiDmsGetCustFeaturesV2(
    WORD *pMlength,
    BYTE *pBuffer,
    getCustomInput *pCustSettInput);

extern enum eQCWWANError UpkQmiDmsGetCustFeaturesV2(
    BYTE                             *pMdmResp,
    struct QmiDmsGetCustFeaturesV2Resp *pApiResp );

#endif /* __DMS_GET_CUST_FEATURES_V2_H__ */
