/*
 * \ingroup dms
 *
 * \file qaDmsIndicationRegister.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaDmsIndicationRegister.c
 *
 * Copyright: © 2016 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __DMS_SWI_INDICATION_REGISTER_H__
#define __DMS_SWI_INDICATION_REGISTER_H__

#include "qaGobiApiDms.h"

/*
 *
 * An enumeration of eQMI_DMS_SWI_INDICATION_REGISTER response TLV IDs
 *
 */
enum eQMI_DMS_SWI_INDICATION_REGISTER_RESP
{
    eTLV_SWI_GET_RESET_INFO_IND    = 0x10,
};

/*
 * This structure contains the SWI Indication Register response parameters.
 *
 * \sa qaGobiApiDms.h for parameter descriptions
 *
 */
struct QmiDmsSwiIndicationRegisterResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;
};

/************
 * Prototypes
 **************/
extern enum eQCWWANError PkQmiDmsIndicationRegister (
    WORD    *pMlength,
    BYTE    *pParamField,
    dmsIndicationRegisterReq *pIndicationRegisterReq  );

extern enum eQCWWANError UpkQmiDmsIndicationRegister (
    BYTE     *pMdmResp,
    struct   QmiDmsSwiIndicationRegisterResp *pAipResp );

#endif /* __DMS_SWI_INDICATION_REGISTER_H__ */

/*
 * \ingroup dms
 *
 * \file qaDmsIndicationRegister.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaDmsIndicationRegister.c
 *
 * Copyright: © 2016 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __DMS_SWI_INDICATION_REGISTER_H__
#define __DMS_SWI_INDICATION_REGISTER_H__

#include "qaGobiApiDms.h"

/*
 *
 * An enumeration of eQMI_DMS_SWI_INDICATION_REGISTER response TLV IDs
 *
 */
enum eQMI_DMS_SWI_INDICATION_REGISTER_RESP
{
    eTLV_SWI_GET_RESET_INFO_IND    = 0x10,
};

/*
 * This structure contains the SWI Indication Register response parameters.
 *
 * \sa qaGobiApiDms.h for parameter descriptions
 *
 */
struct QmiDmsSwiIndicationRegisterResp
{
    /* Every response message must have a results structure */
    struct qmTlvResult results;
};

/************
 * Prototypes
 **************/
extern enum eQCWWANError PkQmiDmsIndicationRegister (
    WORD    *pMlength,
    BYTE    *pParamField,
    dmsIndicationRegisterReq *pIndicationRegisterReq  );

extern enum eQCWWANError UpkQmiDmsIndicationRegister (
    BYTE     *pMdmResp,
    struct   QmiDmsSwiIndicationRegisterResp *pAipResp );

#endif /* __DMS_SWI_INDICATION_REGISTER_H__ */

