/*
 * \ingroup dcs
 *
 * \file    qaDcsSLQSSetLoggingMask.c
 *
 * \brief   Contains Packing and UnPacking routines for the
 *          eQMI_DCS_SET_LOGGING_MASK message.
 *
 * Copyright: © 2014 Sierra Wireless, Inc. all rights reserved
 *
 */
/* include files */

#include "SwiDataTypes.h"
#include "qaQmiBasic.h"
#include "sludefs.h"
#include "qmudefs.h"
#include "qmerrno.h"

#include "qaDcsSLQSSetLoggingMask.h"
#include "qaGobiApiDcs.h"

/******************************************************************************
 * Request handling
 ******************************************************************************/

/*
 * This function packs the SLQSSetLoggingMask parameters
 * to the QMI message SDU
 *
 * \param   pParamField [OUT] - Pointer to storage into which the packed
 *                              data will be placed by this function.
 *
 * \param   pMlength    [OUT] - Total length of built message.
 *
 * \param   level       [IN]  - Level to limit syslogs.
 *
 * \return  eQCWWAN_ERR_NONE
 * \return  eQCWWAN_ERR_MEMORY
 *
 * \sa      qaGobiApiDcs.h for remaining parameter descriptions.
 *
 */
enum eQCWWANError PkQmiDcsSLQSSetLoggingMask(
    WORD      *pMlength,
    BYTE      *pParamField,
    BYTE      level)
{

    return qm_dcs_set_logging_mask_pack( level,
                                      pParamField,
                                      pMlength );
}

/******************************************************************************
 * Response handling
 ******************************************************************************/
/*
 * This function unpacks the SLQSSetLoggingMask response message to a
 * user-provided response structure.
 *
 * \param     pMdmResp   [IN]  - Pointer to packed response from the modem.
 *
 * \param     pApiResp   [OUT] - Pointer to storage to unpack into.
 *
 * \return  eQCWWAN_ERR_NONE
 * \return  eQCWWAN_ERR_MEMORY
 */
enum eQCWWANError  UpkQmiDcsSLQSSetLoggingMask(
    BYTE                               *pMdmResp,
    struct qm_qmi_response_tlvs_values *pApiResp)
{
    return qm_dcs_set_logging_mask_response_unpack( pMdmResp, pApiResp );
}
