/*
 *
 * \ingroup : cbk
 *
 * \file    : qaCbkWdsSWIRMTransferStatisticsInd.c
 *
 * \brief   : Contains Packing and UnPacking routines for the
 *              WDS_SWI_RM_TRANSFER_STATISTICS message.
 *
 * Copyright: © 2015 Sierra Wireless, Inc. all rights reserved
 *
 */

/* include files */
#include "SwiDataTypes.h"
#include "qmudefs.h"
#include "qmerrno.h"
#include "qaGobiApiWds.h"
#include "qaCbkWdsSWIRMTransferStatisticsInd.h"

/******************************************************************************
 * Response handling
 ******************************************************************************/
/*
 * This function unpacks the RM Transfer Statistics Tx Ok Count from the
 * QMI response message to a user provided response structure
 *
 * \param       pTlvData [IN/OUT]  - Pointer to TLV data from which to unpack.
 *
 * \param       pResp    [OUT]     - Pointer to structure containing storage
 *                                     to return data for this TLV.
 *
 * \return      eQCWWAN_ERR_NONE, on success
 */
static enum eQCWWANError qmUnpackTlvStatisticsIndicatorTxOkCount(
    swi_uint8 *pTlvData,
    swi_uint8 *pResp)
{
    DataULongTlv *lResp =
        &(( QmiCbkWdsStatisticsIndState *)pResp)->TxOkConutTlv;

    enum eQCWWANError eRCode = eQCWWAN_ERR_ENUM_BEGIN;
    ULONG ulTemp = 0;
    lResp->TlvPresent = 0;
    eRCode = GetLong( pTlvData, &ulTemp );
    if ( eRCode != eQCWWAN_ERR_NONE )
        return eRCode;
    lResp->ulData = ulTemp;
    lResp->TlvPresent = TRUE;
    return eRCode;
}

/******************************************************************************
 * Response handling
 ******************************************************************************/
/*
 * This function unpacks the RM Transfer Statistics Rx Ok Count from the
 * QMI response message to a user provided response structure
 *
 * \param       pTlvData [IN/OUT]  - Pointer to TLV data from which to unpack.
 *
 * \param       pResp    [OUT]     - Pointer to structure containing storage
 *                                     to return data for this TLV.
 *
 * \return      eQCWWAN_ERR_NONE, on success
 */
static enum eQCWWANError qmUnpackTlvStatisticsIndicatorRxOkCount(
    swi_uint8 *pTlvData,
    swi_uint8 *pResp)
{
    DataULongTlv *lResp =
        &(( QmiCbkWdsStatisticsIndState *)pResp)->RxOkConutTlv;

    enum eQCWWANError eRCode = eQCWWAN_ERR_ENUM_BEGIN;
    ULONG ulTemp = 0;
    eRCode = GetLong( pTlvData, &ulTemp );
    if ( eRCode != eQCWWAN_ERR_NONE )
        return eRCode;
    lResp->ulData = ulTemp;
    lResp->TlvPresent = TRUE;
    return eRCode;
}

/******************************************************************************
 * Response handling
 ******************************************************************************/
/*
 * This function unpacks the RM Transfer Statistics Tx Ok Bytes Count from the
 * QMI response message to a user provided response structure
 *
 * \param       pTlvData [IN/OUT]  - Pointer to TLV data from which to unpack.
 *
 * \param       pResp    [OUT]     - Pointer to structure containing storage
 *                                     to return data for this TLV.
 *
 * \return      eQCWWAN_ERR_NONE, on success
 */
static enum eQCWWANError qmUnpackTlvStatisticsIndicatorTxOkBytesCount(
    swi_uint8 *pTlvData,
    swi_uint8 *pResp)
{
    DataULongLongTlv *lResp =
        &(( QmiCbkWdsStatisticsIndState *)pResp)->TxOkByteCountTlv;

    enum eQCWWANError eRCode = eQCWWAN_ERR_ENUM_BEGIN;
    ULONGLONG ullTemp = 0;
    eRCode = GetLongLong( pTlvData, &ullTemp );
    if ( eRCode != eQCWWAN_ERR_NONE )
        return eRCode;
    lResp->ullData = ullTemp;
    lResp->TlvPresent = TRUE;
    return eRCode;
}

/******************************************************************************
 * Response handling
 ******************************************************************************/
/*
 * This function unpacks the RM Transfer Statistics Rx Ok Bytes Count from the
 * QMI response message to a user provided response structure
 *
 * \param       pTlvData [IN/OUT]  - Pointer to TLV data from which to unpack.
 *
 * \param       pResp    [OUT]     - Pointer to structure containing storage
 *                                     to return data for this TLV.
 *
 * \return      eQCWWAN_ERR_NONE, on success
 */
static enum eQCWWANError qmUnpackTlvStatisticsIndicatorRxOkBytesCount(
    swi_uint8 *pTlvData,
    swi_uint8 *pResp)
{

    DataULongLongTlv *lResp =
        &(( QmiCbkWdsStatisticsIndState *)pResp)->RxOkByteCountTlv;

    enum eQCWWANError eRCode = eQCWWAN_ERR_ENUM_BEGIN;
    ULONGLONG ullTemp = 0;
    eRCode = GetLongLong( pTlvData, &ullTemp );
    if ( eRCode != eQCWWAN_ERR_NONE )
        return eRCode;
    lResp->ullData = ullTemp;
    lResp->TlvPresent = TRUE;
    return eRCode;
}

/******************************************************************************
 * Response handling
 ******************************************************************************/
/*
 * This function unpacks the RM Transfer Statistics Tx Drop Count from the
 * QMI response message to a user provided response structure
 *
 * \param       pTlvData [IN/OUT]  - Pointer to TLV data from which to unpack.
 *
 * \param       pResp    [OUT]     - Pointer to structure containing storage
 *                                     to return data for this TLV.
 *
 * \return      eQCWWAN_ERR_NONE, on success
 */
static enum eQCWWANError qmUnpackTlvStatisticsIndicatorTxDropCount(
    swi_uint8 *pTlvData,
    swi_uint8 *pResp)
{
    DataULongTlv *lResp =
        &((QmiCbkWdsStatisticsIndState *)pResp)->TxDropConutTlv;

    enum eQCWWANError eRCode = eQCWWAN_ERR_ENUM_BEGIN;
    ULONG ulTemp = 0;
    eRCode = GetLong( pTlvData, &ulTemp );
    if ( eRCode != eQCWWAN_ERR_NONE )
        return eRCode;
    lResp->ulData = ulTemp;
    lResp->TlvPresent = TRUE;
    return eRCode;
}

/******************************************************************************
 * Response handling
 ******************************************************************************/
/*
 * This function unpacks the RM Transfer Statistics Rx Drop Count from the
 * QMI response message to a user provided response structure
 *
 * \param       pTlvData [IN/OUT]  - Pointer to TLV data from which to unpack.
 *
 * \param       pResp    [OUT]     - Pointer to structure containing storage
 *                                     to return data for this TLV.
 *
 * \return      eQCWWAN_ERR_NONE, on success
 */
 static enum eQCWWANError qmUnpackTlvStatisticsIndicatorRxDropCount(
    swi_uint8 *pTlvData,
    swi_uint8 *pResp)
{

   DataULongTlv *lResp =
        &((QmiCbkWdsStatisticsIndState *)pResp)->RxDropConutTlv;

    enum eQCWWANError eRCode = eQCWWAN_ERR_ENUM_BEGIN;
    ULONG ulTemp = 0;
    eRCode = GetLong( pTlvData, &ulTemp );
    if ( eRCode != eQCWWAN_ERR_NONE )
        return eRCode;
    lResp->ulData = ulTemp;
    lResp->TlvPresent = TRUE;
    return eRCode;
}

/* Response handlers */

/*
 *
 * This function unpacks the WDS_SWI_RM_TRANSFER_STATISTICS response
 * message to a user-provided response structure.
 *
 * \param     pMdmResp   [IN]  - Pointer to packed response from the modem.
 *
 * \param     pApiResp   [OUT] - Pointer to storage to unpack into.
 *
 * \return    eQCWWAN_ERR_NONE, on success
 *
 */

enum eQCWWANError UpkQmiWdsSWIRMTrasnferStaticsInd(
    BYTE                                *pMdmResp,
    QmiCbkWdsStatisticsIndState *pApiResp )
{
    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    static struct qmTlvUnpackerItem map[] =
    {
        { eTLV_RM_TRANSFER_STATISTICS_INDICATOR_TX_OK_COUNT, &qmUnpackTlvStatisticsIndicatorTxOkCount},
        { eTLV_RM_TRANSFER_STATISTICS_INDICATOR_RX_OK_COUNT, &qmUnpackTlvStatisticsIndicatorRxOkCount},
        { eTLV_RM_TRANSFER_STATISTICS_INDICATOR_TX_OK_BYTES_COUNT, &qmUnpackTlvStatisticsIndicatorTxOkBytesCount},
        { eTLV_RM_TRANSFER_STATISTICS_INDICATOR_RX_OK_BYTES_COUNT, &qmUnpackTlvStatisticsIndicatorRxOkBytesCount},
        { eTLV_RM_TRANSFER_STATISTICS_INDICATOR_TX_DROP_COUNT, &qmUnpackTlvStatisticsIndicatorTxDropCount},
        { eTLV_RM_TRANSFER_STATISTICS_INDICATOR_RX_DROP_COUNT, &qmUnpackTlvStatisticsIndicatorRxDropCount},
        { eTLV_TYPE_INVALID, NULL } /* Important. Sentinel.
                                     * Signifies last item in map.
                                     */
    };

    eRCode = qmunpackresp( pMdmResp,
                           (BYTE *)pApiResp,
                           map,
                           eQMI_WDS_SWI_RM_TRANSFER_STATISTICS );                           

    return eRCode;
}



