/**
  * \ingroup cbk
  *
  * \file    qaCbkWdsSWIDHCPv4ClientLeaseInd.h
  *
  * \brief   This file contains definitions, enumerations, structures and
  *          forward declarations for qaCbkWdsSWIDHCPv4ClientLeaseInd.c
  *
  * Copyright: © 2016 Sierra Wireless, Inc. all rights reserved
  *
  */

#ifndef __WDS_SWI_DHCPV4_CLIENT_LEASE_IND__
#define __WDS_SWI_DHCPV4_CLIENT_LEASE_IND__

#include "qaGobiApiWds.h"

/* An enumeration of eQMI_WDS_SWI_DHCPV4_CLIENT_LEASE_IND response TLV IDs */
enum eQMI_WDS_SWI_DHCPV4_CLIENT_LEASE_IND
{
    eTLV_DHCP_CLIENT_PROFILE_ID  = 0x01,
    eTLV_DHCP_CLIENT_LEASE_STATE = 0x02,
    eTLV_DHCP_CLIENT_IP_ADDRESS  = 0x10,
    eTLV_DHCP_CLIENT_LEASE_OPT   = 0x11,
};

/*
 * eQMI_WDS_SWI_DHCPV4_CLIENT_LEASE_IND TLVs defined below
 */

/*
 * Name:    DHCPProfileIdTlv
 *
 * Purpose: Structure used to store DHCP profile id TLV Value.
 *
 * Members: TlvPresent    - Boolean indicating the presence of the TLV
 *                          in the QMI response
 *
 */
typedef struct
{
    BYTE TlvPresent;
    BYTE profileType;
    BYTE profileId;
} DHCPProfileIdTlv;

/*
 * Name:    DHCPLeaseStateTlv
 *
 * Purpose: Structure used to store DHCP lease state TLV Value.
 *
 * Members: TlvPresent    - Boolean indicating the presence of the TLV
 *                          in the QMI response
 *
 */
typedef struct
{
    BYTE TlvPresent;
    BYTE leaseState;
} DHCPLeaseStateTlv;

/*
 * Name:    IPv4AdTlv
 *
 * Purpose: Structure used to store IPv4 address TLV Value.
 *
 * Members: TlvPresent    - Boolean indicating the presence of the TLV
 *                          in the QMI response
 */
typedef struct
{
    BYTE TlvPresent;
    ULONG IPv4Addr;
} IPv4AdTlv;

/*
 * Name:    DHCPOpt
 *
 * Purpose: Structure used to store DHCP option code.
 *
 * Members: TlvPresent    - Boolean indicating the presence of the TLV
 *                          in the QMI response
 */
typedef struct
{
    BYTE optCode;
    BYTE optValLen;
    BYTE *pOptVal;
} DHCPOpt;

/*
 * Name:    DHCPLeaseOptTLV
 *
 * Purpose: Structure used to store all DHCP lease options TLV.
 *
 * Members: TlvPresent    - Boolean indicating the presence of the TLV
 *                          in the QMI response
 */
typedef struct
{
    BYTE TlvPresent;
    BYTE numOpt;
    DHCPOpt optList[DHCP_MAX_NUM_OPTIONS];
    BYTE optListData[DHCP_OPTION_DATA_BUF_SIZE]; /* internal buffer to store option data */
} DHCPLeaseOptTlv;


/*
 * Name:    QmiCbkWdsDHCPv4ClientLeaseInd
 *
 * Purpose: Structure used to store all DUN Call Info Parameters.
 *
 * Members: DHCPLeaseStateTlv - Structure containing the Lease State  TLV
 *          IPv4AdTlv         - Structure containing the IPv4 Address TLV
 *          DHCPLeaseOptTlv   - Structure containing the Lease Option TLV
 * Note:    None
 */
typedef struct {
    DHCPProfileIdTlv   ProfileIdTlv;
    DHCPLeaseStateTlv  DHCPv4LeaseStateTlv;
    IPv4AdTlv          IPv4AddrTlv;
    DHCPLeaseOptTlv    DHCPv4LeaseOptTlv;
} QmiCbkWdsDHCPv4ClientLeaseInd;

/*
 * Prototypes
 */
 
extern enum eQCWWANError UpkQmiWdsSWIDHCPv4ClientLeaseInd(
    BYTE                          *pMdmResp,
    QmiCbkWdsDHCPv4ClientLeaseInd *pApiResp );

    
#endif /* __WDS_SWI_DHCPV4_CLIENT_LEASE_IND__ */
