/*
 * \ingroup cbk
 *
 * \file    qaCbkWdsDUNCallInfoInd.h
 *
 * \brief   This file contains definitions, enumerations, structures and
 *          forward declarations for qaCbkWdsDUNCallInfoInd.c
 *
 * Copyright: © 2014 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __WDS_DUN_CALL_INFO_IND_H__
#define __WDS_DUN_CALL_INFO_IND_H__

#include  "qaGobiApiCbk.h"

/* An enumeration of eQMI_WDS_DUN_CALL_INFO_IND response TLV IDs */
enum eQMI_WDS_DUN_CALL_INFO_IND
{
    eTLV_MDM_CONN_STAT     = 0x10,
    eTLV_LAST_CALL_END_RSN = 0x11,
    eTLV_TX_OK_BYTES_CNT   = 0x12,
    eTLV_RX_OK_BYTES_CNT   = 0x13,
    eTLV_DORMANCY_STAT     = 0x14,
    eTLV_DATA_BEAR_TCH     = 0x15,
    eTLV_CHAN_RATE         = 0x16,
};

/*
 * eQMI_WDS_DUN_CALL_INFO_IND TLVs defined below
 */

/*
 * Name:    ConnStatusTlv
 *
 * Purpose: Structure used to store all Connection Status TLV Value.
 *
 * Members: TlvPresent    - Boolean indicating the presence of the TLV
 *                          in the QMI response
 *
 *          MDMConnStatus - Modem Connection Status
 */
struct ConnStatusTlv
{
    BYTE TlvPresent;
    BYTE MDMConnStatus;
};

/*
 * Name:    LastMdmCallEndRsnTlv
 *
 * Purpose: Structure used to store all Last Modem Call End Reason TLV Value.
 *
 * Members: TlvPresent    - Boolean indicating the presence of the TLV
 *                          in the QMI response
 *
 *          CallEndReason - Call End Reason
 */
struct LastMdmCallEndRsnTlv
{
    BYTE TlvPresent;
    WORD CallEndReason;
};

/*
 * Name:    TXBytesOKTlv
 *
 * Purpose: Structure used to store all TX Bytes OK TLV Value.
 *
 * Members: TlvPresent  - Boolean indicating the presence of the TLV
 *                        in the QMI response
 *
 *          TxByteOKCnt - TX Bytes OK
 */
struct TXBytesOKTlv
{
    BYTE      TlvPresent;
    ULONGLONG TxByteOKCnt;
};

/*
 * Name:    RXBytesOKTlv
 *
 * Purpose: Structure used to store all RX Bytes OK TLV Value.
 *
 * Members: TlvPresent  - Boolean indicating the presence of the TLV
 *                        in the QMI response
 *
 *          RxByteOKCnt - Rx Bytes OK
 */
struct RxBytesOKTlv
{
    BYTE      TlvPresent;
    ULONGLONG RxByteOKCnt;
};

/*
 * Name:    DormStatTlv
 *
 * Purpose: Structure used to store all Dormancy Status TLV Value.
 *
 * Members: TlvPresent   - Boolean indicating the presence of the TLV
 *                         in the QMI response
 *
 *          DormancyStat - Dormancy Status
 */
struct DormStatTlv
{
    BYTE TlvPresent;
    BYTE DormancyStat;
};

/*
 * Name:    DataBearTechTlv
 *
 * Purpose: Structure used to store all Data Bearer technology TLV Value.
 *
 * Members: TlvPresent     - Boolean indicating the presence of the TLV
 *                           in the QMI response
 *
 *          DataBearerTech - Data Bearer Technology
 */
struct DataBearTechTlv
{
    BYTE TlvPresent;
    BYTE DataBearerTech;
};

/*
 * Name:    ChannelRateTlv
 *
 * Purpose: Structure used to store all channel rate TLV Value.
 *
 * Members: TlvPresent  - Boolean indicating the presence of the TLV
 *                        in the QMI response
 *
 *          ChannelRate - Channel rate
 */
struct ChannelRateTlv
{
    BYTE        TlvPresent;
    channelRate ChannelRate;
};

/*
 * Name:    QmiCbkWdsDUNCallInfoInd
 *
 * Purpose: Structure used to store all DUN Call Info Parameters.
 *
 * Members: CSTlv    - Structure containing the Connection Status TLV
 *          LMCERTlv - Structure containing the Last Modem Call End Reason TLV
 *          TXBOTlv  - Structure containing the TX bytes OK Count TLV
 *          RXBOTlv  - Structure containing the RX bytes OK Count TLV
 *          DSTlv    - Structure containing the dormancy status TLV
 *          DBTTlv   - Structure containing the Data Bearer Technology TLV
 *          CRTlv    - Structure containing the channel rate TLV
 * Note:    None
 */
struct QmiCbkWdsDUNCallInfoInd{
    struct ConnStatusTlv        CSTlv;
    struct LastMdmCallEndRsnTlv LMCERTlv;
    struct TXBytesOKTlv         TXBOTlv;
    struct RxBytesOKTlv         RXBOTlv;
    struct DormStatTlv          DSTlv;
    struct DataBearTechTlv      DBTTlv;
    struct ChannelRateTlv       CRTlv;
};

/*************
 * Prototypes
 **************/
enum eQCWWANError UpkQmiCbkWdsDUNCallInfoInd (
    BYTE                           *pMdmResp,
    struct QmiCbkWdsDUNCallInfoInd *pApiResp );

#endif /* __WDS_DUN_CALL_INFO_IND_H__ */
