/*
 * \ingroup cbk
 *
 * \file    qaCbkUimSlotStatusChangeInd.h
 *
 * \brief   Contains UnPacking routines for the eQMI_UIM_SLOT_STATUS_IND message.
 *
 * Copyright: © 2016 Sierra Wireless, Inc. all rights reserved
 *
 */

/* include files */

#include "SwiDataTypes.h"
#include "qmudefs.h"
#include "qmerrno.h"
#include "qaCbkUimSlotStatusChangeInd.h"

/*
 * This function unpacks the Slot Change Status TLV parameters from the QMI
 * indication message to a user provided response structure
 *
 * \param   pTlvData - Pointer to TLV data from which to unpack.
 *
 * \param   pResp    - Pointer to structure containing storage
 *                     to return data for this TLV.
 *
 * \return: eQCWWAN_ERR_NONE on success, eQCWWAN_xxx error value otherwise
 */
package enum eQCWWANError UnpackCbkTlvSlotChangeStatus(
    BYTE *pTlvData,
    BYTE *pResp )
{
    /* Get the required TLV structure to the local pointer */
    UIMSlotStatusChangeInfo *lResp = ((UIMSlotStatusChangeInfo *)pResp);
    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;
    BYTE              lcount = 0;
    BYTE             scount = 0;
    /* Copy the Card Status Values into the List */
    eRCode = GetByte( pTlvData, &lResp->bNumberOfPhySlots );
    if ( eQCWWAN_ERR_NONE != eRCode )
    {
        return eRCode;
    }
    
    for(scount=0;scount<lResp->bNumberOfPhySlots;scount++)
    {
        eRCode = GetLong( pTlvData, &lResp->slotsstatusChange.uimSlotStatus[scount].uPhyCardStatus );
        if ( eQCWWAN_ERR_NONE != eRCode )
        {
            return eRCode;
        }

        eRCode = GetLong( pTlvData, &lResp->slotsstatusChange.uimSlotStatus[scount].uPhySlotStatus );
        if ( eQCWWAN_ERR_NONE != eRCode )
        {
            return eRCode;
        }

        eRCode = GetByte( pTlvData, &lResp->slotsstatusChange.uimSlotStatus[scount].bLogicalSlot );
        if ( eQCWWAN_ERR_NONE != eRCode )
        {
            return eRCode;
        }

        eRCode = GetByte( pTlvData, &lResp->slotsstatusChange.uimSlotStatus[scount].bICCIDLength );

        if ( eQCWWAN_ERR_NONE != eRCode )
        {
            return eRCode;
        }

        for ( lcount = 0; lcount < lResp->slotsstatusChange.uimSlotStatus[scount].bICCIDLength; lcount++ )
        {
            
            eRCode = GetByte( pTlvData, &lResp->slotsstatusChange.uimSlotStatus[scount].bICCID[lcount] );
            if ( eQCWWAN_ERR_NONE != eRCode )
            {
                return eRCode;
            }
        }
    }
    return eRCode;
}

/*
 * This function unpacks the Slots Status Change Indication message to a
 * user-provided response structure.
 *
 * \param   pMdmResp - Pointer to packed response from the modem.
 *
 * \param   pApiResp - Pointer to storage to unpack into.
 *
 * \return: eQCWWAN_ERR_NONE on success, eQCWWAN_xxx error value otherwise
 */
package enum eQCWWANError UpkQmiCbkUIMSlotStatusChangeInd(
    BYTE                *pMdmResp,
    UIMSlotStatusChangeInfo *pApiResp )
{
    enum eQCWWANError eRCode;

    static struct qmTlvUnpackerItem map[] =
    {
        { eTLV__UIM_SLOT_TATUS_NUM_PHY_SLOTS,
            &UnpackCbkTlvSlotChangeStatus },
        { eTLV_TYPE_INVALID, NULL } /* Important. Sentinel.
                                     * Signifies last item in map.
                                     */
    };

    eRCode = qmunpackresp( pMdmResp,
                           (BYTE *)pApiResp,
                           map,
                           eQMI_UIM_SLOT_STATUS_IND );
    return eRCode;
}
