/*
 * \ingroup cbk
 *
 * \file    qaCbkQosEventStatusInd.h
 *
 * \brief   This file contains definitions, enumerations, structures and
 *          forward declarations for qaCbkQosEventStatusInd.c
 *
 * Copyright: © 2013 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __QOS_EVENT_REPORT_IND_H__
#define __QOS_EVENT_REPORT_IND_H__

#define V6_MAX_ADD_LEN 16

/* An enumeration of eQMI_QOS_SET_EVENT_REPORT_IND response TLV IDs */
enum eQMI_QOS_SET_EVENT_REPORT_IND
{
    eTLV_FLOW_INFO            = 0x10
};

enum
{
    eTLV_FLOW_STATE = 0x10,
    eTLV_FLOW_TX    = 0x11,
    eTLV_FLOW_RX    = 0x12,
    eTLV_FILTER_TX  = 0x13,
    eTLV_FILTER_RX  = 0x14,
    eTLV_FILTER_NI  = 0x15,
    eTLV_BEARER_ID  = 0x16
};

struct FlowInfoTlv
{
    BYTE    TlvPresent;
    ULONG   id;
    BYTE    isNew;
    BYTE    state;
};

struct DataRateTlv
{
    BYTE    TlvPresent;
    ULONG   dataRateMax;
    ULONG   guaranteedRate;
};

struct LatencyTlv
{
    BYTE    TlvPresent;
    ULONG   latency;
};

struct JitterTlv
{
    BYTE    TlvPresent;
    ULONG   jitter;
};

struct QciTlv
{
    BYTE    TlvPresent;
    BYTE    qci;
};

typedef struct
{
    BYTE    TlvPresent;
    BYTE    val;
} sSigIndTlv;

typedef struct
{
    BYTE    TlvPresent;
    BYTE    val;
} sIMCNFlagTlv;

typedef struct
{
    BYTE    TlvPresent;
    BYTE    val;
} sFlowPriorityTlv;

typedef struct
{
    BYTE    TlvPresent;
    BYTE    val;
} sTHPriorityTlv;

typedef struct
{
    BYTE    TlvPresent;
    BYTE    val;
} sRBErrorRateTlv;

typedef struct
{
    BYTE    TlvPresent;
    ULONG   val;
} sMaxAllowedPktSizeTlv;

typedef struct
{
    BYTE    TlvPresent;
    ULONG   val;
} sMinPolPktSizeTlv;

typedef struct
{
    BYTE    TlvPresent;
    WORD    multiplier;
    WORD    exponent;
} sPktErrorRateTlv;

typedef struct
{
    BYTE    TlvPresent;
    WORD   val;
} s3GPP2ProIDTlv;

typedef struct
{
    BYTE    TlvPresent;
    ULONG   peakRate;
    ULONG   tokenRate;
    ULONG   bucketSize;
} sTokenBucketTlv;

typedef struct
{
    BYTE    TlvPresent;
    BYTE    val;
} sIPTrafficClassTlv;

struct FlowGrantedTlv
{
    BYTE    TlvPresent;
    BYTE    index;
    struct  DataRateTlv dataRateTlv;
    struct  LatencyTlv  latencyTlv;
    struct  JitterTlv   jitterTlv;
    struct  QciTlv      qciTlv;
    sIPTrafficClassTlv  trafficClass;
    sTokenBucketTlv     tokenBucket;
    s3GPP2ProIDTlv      profID;
    sPktErrorRateTlv    pktErrorRate;
    sMinPolPktSizeTlv   minPolPktSize;
    sMaxAllowedPktSizeTlv maxAllowedpktSize;
    sRBErrorRateTlv     RBErrorRate;
    sTHPriorityTlv      thPriority;
    sFlowPriorityTlv    flowPriorityTlv;
    sIMCNFlagTlv        IMCNFlagTlv;
    sSigIndTlv          sigInd;
};

struct V4tosTlv
{
    BYTE    TlvPresent;
    BYTE    val;
    BYTE    mask;
};

struct V6tcTlv
{
    BYTE    TlvPresent;
    BYTE    val;
    BYTE    mask;
};

typedef struct
{
    BYTE    TlvPresent;
    BYTE    val;
} sNxtHdrProtoTlv;

typedef struct
{
    BYTE    TlvPresent;
    WORD    val;
} sPrecedenceTlv;

typedef struct
{
    BYTE    TlvPresent;
    WORD    val;
} sIdTlv;

typedef struct
{
    BYTE    TlvPresent;
    ULONG   srcAdd;
    ULONG   srcAddMask;
} ipV4FilterSrcAddTLV;

typedef struct
{
    BYTE    TlvPresent;
    ULONG   destAdd;
    ULONG   destAddMask;
} ipV4FilterDestAddTLV;

typedef struct
{
    BYTE    TlvPresent;
    BYTE    srcAdd[V6_MAX_ADD_LEN];
    BYTE    srcAddPfxLen;
} ipV6FilterSrcAddTLV;

typedef struct
{
    BYTE    TlvPresent;
    BYTE    destAdd[V6_MAX_ADD_LEN];
    BYTE    destAddPfxLen;
} ipV6FilterDestAddTLV;

typedef struct
{
    BYTE    TlvPresent;
    ULONG   flowLbl;
} ipV6FilterFlowLblTLV;

typedef struct
{
    BYTE    TlvPresent;
    WORD    port;
    WORD    portRange;
} filterPortTLV;

typedef struct
{
    BYTE    TlvPresent;
    ULONG   val;
} espSPITLV;

struct FilterTlv
{
    BYTE                 TlvPresent;
    BYTE                 index;
    BYTE                 ver;
    struct  V4tosTlv     v4tosTlv;
    struct  V6tcTlv      v6tcTlv;
    sNxtHdrProtoTlv      nxtHdrProtoTlv;
    sPrecedenceTlv       precedenceTlv;
    sIdTlv               idTlv;
    ipV4FilterSrcAddTLV  ipV4SrcAddTLV;
    ipV4FilterDestAddTLV ipV4DestAddTLV;
    ipV6FilterSrcAddTLV  ipV6SrcAddTLV;
    ipV6FilterDestAddTLV ipV6DestAddTLV;
    ipV6FilterFlowLblTLV v6FlowLbl;
    filterPortTLV        tcpSrcPort;
    filterPortTLV        tcpDestPort;
    filterPortTLV        udpSrcPort;
    filterPortTLV        udpDestPort;
    espSPITLV            espSPI;
    filterPortTLV        tpSrcPort;
    filterPortTLV        tpDestPort;
};

/*
 * Name:    QmiCbkQosEventReportInd
 *
 * Purpose: Structure used to store all QMI Notification parameters.
 *
 */
struct QmiCbkQosEventReportInd{
    BYTE    TlvPresent;
    ULONG   id;
    BYTE    isNew;
    BYTE    state;
    struct  FlowInfoTlv flowInfoTlv;
    struct  FlowGrantedTlv txFlowTlv;
    struct  FlowGrantedTlv rxFlowTlv;
    struct  FilterTlv txFilterTlv[MAX_QOS_FILTER_TLV];
    struct  FilterTlv rxFilterTlv[MAX_QOS_FILTER_TLV];
    BYTE    tlvIdx;
    BYTE    bearerID;
};

typedef struct {
    dataRate    dataRate;
    ULONG       latency;
    ULONG       jitter;
    BYTE        qci;
    WORD        profileID;
    BYTE        trafficClass;
    tokenBucket tokenBucket;
    BYTE        index;
    pktErrRate  pktErrRate;
    ULONG       minPolicedPktSz;
    ULONG       maxAllowedPktSz;
    WORD        RBErrorRate;
    BYTE        THPriority;
    BYTE        flowPriority;
    BYTE        ImCnFlag;
    BYTE        SigInd;
} sFlow;

typedef struct {
    Tos         tos;
    IPv6TrafCls iPv6TrafCls;
    BYTE        nxtHdrProto;
    WORD        precedence;
    WORD        filterId;
    IPv4Addr     ipV4SrcAddr;
    IPv4Addr     ipV4DstAddr;
    IPv6Addr     ipV6SrcAddr;
    IPv6Addr     ipV6DstAddr;
    IPv6TrafCls  ipV6TrafCls;
    ULONG        ipV6Label;
    Port         tcpSrcPort;
    Port         tcpDstPort;
    Port         udpSrcPort;
    Port         udpDstPort;
    ULONG        espSpi;
    Port         tranSrcPort;
    Port         tranDstPort;
} sFilter;

/*************
 * Prototypes
 **************/
enum eQCWWANError UpkQmiCbkQosEventInd (
    BYTE     *pMdmResp,
    struct QmiCbkQosEventReportInd *pAipResp );

#endif /* __QOS_EVENT_REPORT_IND_H__ */
