/*
 * \ingroup cbk
 *
 * \file qaCbkNasSwiRankIndicatorInd.c
 *
 * \brief  Contains UnPacking routines for the
 *         eQMI_NAS_SWI_RANK_INDICATOR_IND message.
 *
 * Copyright:  2015 Sierra Wireless, Inc. all rights reserved
 *
 */

/* include files */

#include "SwiDataTypes.h"
#include "qmudefs.h"
#include "qmerrno.h"
#include "qaCbkNasSwiRankIndicatorInd.h"
#include "qaGobiApiCbk.h"

/*****************************************************************************
 * Unpacking functions
 ******************************************************************************/
enum eQCWWANError UnpackTlvRankIndicator(
    BYTE *pTlvData,
    BYTE *pResp )
{
    enum eQCWWANError eRCode =  eQCWWAN_ERR_NONE;
    RankIndicatorTlv *lResp =
            &((QmiCbkNasSwiRankIndicatorInd *)pResp)->rankIndicatorTlv;
    lResp->TlvPresent = FALSE;
    eRCode = GetLong( pTlvData, &(lResp->count0) );
    if ( eQCWWAN_ERR_NONE != eRCode )
    {
       return eRCode;
    }
    eRCode = GetLong( pTlvData, &(lResp->count1) );
    if( eRCode != eQCWWAN_ERR_NONE )
    {
       return eRCode;
    }
    lResp->TlvPresent = TRUE;
    return eRCode;
}

enum eQCWWANError UpkQmiCbkNasSwiRankIndicatorInd(
    BYTE                                 *pMdmResp,
    QmiCbkNasSwiRankIndicatorInd *pApiResp )
{
    enum eQCWWANError eRCode;

    static struct qmTlvUnpackerItem map[] =
    {
        { eTLV_NAS_SWI_RANK_INDICATOR_IND, &UnpackTlvRankIndicator },
        { eTLV_TYPE_INVALID,               NULL }  /* Important. Sentinel.
                                                    * Signifies last item in map.
                                                    */
    };
    eRCode = qmunpackresp( pMdmResp,
                          (BYTE*)pApiResp,
                          map,
                          eQMI_NAS_SWI_RANK_INDICATOR_IND );
    return eRCode;
}


