/*
 * \ingroup cbk
 *
 * \file qaCbkNasSwiOTAMessageInd.c
 *
 * \brief  Contains UnPacking routines for the
 *         QMI_NAS_SWI_OTA_MESSAGE_IND message.
 *
 * Copyright: © 2014 Sierra Wireless, Inc. all rights reserved
 *
 */

/* include files */

#include "SwiDataTypes.h"
#include "qmudefs.h"
#include "qmerrno.h"
#include "qaCbkNasSwiOTAMessageInd.h"
#include "qaGobiApiCbk.h"

/*****************************************************************************
 * Unpacking functions
 ******************************************************************************/
enum eQCWWANError UnpackTlvOTAMessage(
    BYTE *pTlvData,
    BYTE *pResp )
{
    enum eQCWWANError eRCode =  eQCWWAN_ERR_NONE;
    struct OTAMessageTlv *lResp =
            &((struct QmiCbkNasSwiOTAMessageInd *)pResp)->otaMsgTlv;
    WORD length = 0;

    /* Get OTA message type from the response */
    eRCode = GetLong( pTlvData, &(lResp->message_type));
    if ( eQCWWAN_ERR_NONE != eRCode )
    {
       return eRCode;
    }
    eRCode = GetWord( pTlvData, &(lResp->data_len) );
    if ( eQCWWAN_ERR_NONE != eRCode )
    {
       return eRCode;
    }
    /* data length is reported by the QMI notification */
    length = lResp->data_len;
    /* get the raw data */
    eRCode = GetStream( pTlvData, lResp->data_buf, length);
    if( eRCode == eQCWWAN_ERR_NONE )
    {
       lResp->TlvPresent = TRUE;
    }
    return eRCode;
}

enum eQCWWANError UnpackTlvLteNasReleaseInfo(
    BYTE *pTlvData,
    BYTE *pResp )
{
    enum eQCWWANError eRCode =  eQCWWAN_ERR_NONE;
    struct LteNasReleaseInfoTlv *lResp =
            &((struct QmiCbkNasSwiOTAMessageInd *)pResp)->nasRelInfoTlv;

    eRCode = GetByte( pTlvData, &(lResp->nas_release));
    if ( eQCWWAN_ERR_NONE != eRCode )
    {
       return eRCode;
    }
    eRCode = GetByte( pTlvData, &(lResp->nas_major));
    if ( eQCWWAN_ERR_NONE != eRCode )
    {
       return eRCode;
    }
    eRCode = GetByte( pTlvData, &(lResp->nas_minor));
    if ( eQCWWAN_ERR_NONE == eRCode )
    {
       lResp->TlvPresent = TRUE;
    }
    return eRCode;
}

enum eQCWWANError UnpackTlvTime(
    BYTE *pTlvData,
    BYTE *pResp )
{
    enum eQCWWANError eRCode =  eQCWWAN_ERR_NONE;
    struct TimeInfoTlv*lResp =
            &((struct QmiCbkNasSwiOTAMessageInd *)pResp)->timeTlv;

    /* Get the time field of the QMI notification */
    eRCode = GetLongLong( pTlvData, &(lResp->time));
    if ( eQCWWAN_ERR_NONE == eRCode )
    {
       lResp->TlvPresent = TRUE;
    }
    return eRCode;
}

enum eQCWWANError UpkQmiCbkNasSwiOTAMessageInd(
    BYTE                                 *pMdmResp,
    struct QmiCbkNasSwiOTAMessageInd *pApiResp )
{
    enum eQCWWANError eRCode;

    static struct qmTlvUnpackerItem map[] =
    {
        { eTLV_OTA_MESSAGE_IND, &UnpackTlvOTAMessage },
        { eTLV_LTE_NAS_RELEASE_INFO_IND, &UnpackTlvLteNasReleaseInfo },
        { eTLV_TIME_IND, &UnpackTlvTime},
        { eTLV_TYPE_INVALID,               NULL }  /* Important. Sentinel.
                                                    * Signifies last item in map.
                                                    */
    };
    eRCode = qmunpackresp( pMdmResp,
                          (BYTE*)pApiResp,
                          map,
                          eQMI_NAS_SWI_INDICATION_REGISTER );
    return eRCode;
}

