/*
 * \ingroup cbk
 *
 * \file    qaCbkNasSwiRankIndicatorInd.h
 *
 * \brief   This file contains definitions, enumerations, structures and
 *          forward declarations for qaCbkNasSwiRankIndicatorInd.c
 *
 * Copyright:  2015 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __NAS_SWI_RANK_INDICATOR_IND_H__
#define __NAS_SWI_RANK_INDICATOR_IND_H__
#include "qaGobiApiCbk.h"

/*
 * An enumeration of eQMI_NAS_SWI_RANK_INDICATOR_IND
 * response TLV IDs
 *
 */
enum eQMI_NAS_SWI_RANK_INDICATOR
{
    eTLV_NAS_SWI_RANK_INDICATOR_IND    = 0x01,
};

typedef struct  {
    BYTE    TlvPresent;
    ULONG    count0;
    ULONG    count1;
}RankIndicatorTlv;

/*
 * Name:    QmiCbkNasSwiRankIndicatorInd
 *
 * Purpose: Structure used to store all QMI Notification parameters.
 *
 * Members: HDRPersonalityInd    - See \ref HDrPersonalityInd for more Info
 *
 * Note:    None
 */
typedef struct {
    RankIndicatorTlv rankIndicatorTlv;
}QmiCbkNasSwiRankIndicatorInd;


/*************
 * Prototypes
 **************/
enum eQCWWANError UpkQmiCbkNasSwiRankIndicatorInd(
    BYTE                                 *pMdmResp,
    QmiCbkNasSwiRankIndicatorInd *pApiResp );

#endif /* __NAS_SWI_RANK_INDICATOR_IND_H__ */

