/*
 * \ingroup cbk
 *
 * \file    qaCbkNasSwiOTAMessageInd.h
 *
 * \brief   This file contains definitions, enumerations, structures and
 *          forward declarations for qaCbkNasSwiOTAMessageInd.c
 *
 * Copyright: © 2014 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __NAS_SWI_OTA_MESSAGE_IND_H__
#define __NAS_SWI_OTA_MESSAGE_IND_H__
#include "qaGobiApiCbk.h"

/*
 * An enumeration of eQMI_NAS_SWI_OTA_MESSAGE_IND
 * response TLV IDs
 *
 */
enum eQMI_NAS_SWI_OTA_MESSAGE_IND
{
    eTLV_OTA_MESSAGE_IND     = 0x01,
    eTLV_LTE_NAS_RELEASE_INFO_IND = 0x10,
    eTLV_TIME_IND = 0x11
};

struct OTAMessageTlv {
    BYTE    TlvPresent;
    ULONG    message_type;
    WORD    data_len;
    BYTE    data_buf[2048];
};

struct LteNasReleaseInfoTlv {
    BYTE    TlvPresent;
    BYTE    nas_release;
    BYTE    nas_major;
    BYTE    nas_minor;
};

struct TimeInfoTlv {
    BYTE    TlvPresent;
    ULONGLONG time;
};

/*
 * Name:    QmiCbkNasSwiOTAMessageInd
 *
 * Purpose: Structure used to store all QMI Notification parameters.
 *
 * Members: HDRPersonalityInd    - See \ref HDrPersonalityInd for more Info
 *
 * Note:    None
 */
struct QmiCbkNasSwiOTAMessageInd {
    struct OTAMessageTlv otaMsgTlv;
    struct LteNasReleaseInfoTlv nasRelInfoTlv;
    struct TimeInfoTlv timeTlv;
};

/*************
 * Prototypes
 **************/
enum eQCWWANError UpkQmiCbkNasSwiOTAMessageInd(
    BYTE                                 *pMdmResp,
    struct QmiCbkNasSwiOTAMessageInd *pApiResp );

#endif /* __NAS_SWI_OTA_MESSAGE_IND_H__ */

