/*
 * \ingroup cbk
 *
 * \file qaCbkNasLteCPHYCAInd.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaCbkNasLteCPHYCAInd.c
 *
 * Copyright: © 2012 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __NAS_NAS_LTE_CPHY_CA_IND_H__
#define __NAS_NAS_LTE_CPHY_CA_IND_H__

#include "qaGobiApiCbk.h"


/*
 * An enumeration of eQMI_NAS_SYS_INFO_IND response TLV IDs
 *
 */
enum eQMI_NAS_NAS_LTE_CPHY_CA_IND
{
    eTLV_IND_NAS_LTE_CPHY_CA_SCELL_IND_TYPE     = 0x01,
    eTLV_IND_NAS_LTE_CPHY_CA_SCELL_DL_BW        = 0x10,
    eTLV_IND_NAS_LTE_CPHY_CA_SCELL_INFO         = 0x11,
    eTLV_IND_NAS_LTE_CPHY_CA_PCELL_INFO         = 0x12,
    eTLV_IND_NAS_LTE_CPHY_CA_SCELL_INDEX        = 0x13,
    
};

typedef struct
{
    PhyCaAggScellIndType    sPhyCaAggScellIndType;
    PhyCaAggScellDlBw       sPhyCaAggScellDlBw;
    PhyCaAggScellInfo       sPhyCaAggScellInfo;
    PhyCaAggPcellInfo       sPhyCaAggPcellInfo;
    PhyCaAggScellIndex      sPhyCaAggPcellIndex;
} NasLTECphyCaInfo;


/*
 * Prototypes
 *
 */
enum eQCWWANError UpkQmiCbkNasLteCphyCaInd(
    BYTE       *pMdmResp,
    QmiCbkNasLTECphyCaInfo *pApiResp );

#endif /* __NAS_NAS_LTE_CPHY_CA_IND_H__ */
