/*
 * \ingroup cbk
 *
 * \file qaCbkLocInjectPositionInd.c
 *
 * \brief Contains UnPacking routines for the
 *        QMI_LOC_INJECT_POSITION_IND message.
 *
 * Copyright: © 2015 Sierra Wireless, Inc. all rights reserved
 *
 */

#include "SwiDataTypes.h"
#include "qmudefs.h"
#include "qmerrno.h"
#include "sludefs.h"
#include "qaCbkLocInjectPositionInd.h"

package enum eQCWWANError UnpackCbkTlvInjectPosition(
        BYTE *pTlvData,
        BYTE *pResp )
{
    QmiCbkLocInjectPositionInd *pStatus;
    pStatus = (QmiCbkLocInjectPositionInd *) pResp;

    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    eRCode = GetLong( pTlvData, &(pStatus->status));

    return eRCode;
}

package enum eQCWWANError UpkQmiCbkLocInjectPositionInd(
        BYTE                  *pMdmResp,
        QmiCbkLocInjectPositionInd   *pStatus)
{
    enum eQCWWANError eRCode;

    static struct qmTlvUnpackerItem map[] =
    {
        { eTLV_INJECT_POSITION_STATUS,     &UnpackCbkTlvInjectPosition },
        { eTLV_TYPE_INVALID,                NULL } /* Important. Sentinel.
                                                    * Signifies last item in map.
                                                    */
    };

    eRCode = qmunpackresp( pMdmResp,
            (BYTE *)pStatus,
            map,
            eQMI_LOC_INJECT_POSITION );
    return eRCode;
}
