/*
 * \ingroup cbk
 *
 * \file qaCbkLocEngineStateInd.c
 *
 * \brief Contains UnPacking routines for the
 *        QMI_LOC_EVENT_ENGINE_STATE_IND message.
 *
 * Copyright: © 2016 Sierra Wireless, Inc. all rights reserved
 *
 */

/* include files */

#include "SwiDataTypes.h"
#include "qmudefs.h"
#include "qmerrno.h"
#include "sludefs.h"
#include "qaCbkLocEngineStateInd.h"

/*
 * This function unpacks the engine state TLV from the QMI indication
 * message to a user provided response structure
 *
 * \param   pTlvData - Pointer to TLV data from which to unpack.
 *
 * \param   pResp    - Pointer to structure containing storage
 *                     to return data for this TLV.
 *
 * \return: eQCWWAN_ERR_NONE on success, eQCWWAN_xxx error value otherwise
 */
package enum eQCWWANError UnpackCbkTlvEngineState(
    BYTE *pTlvData,
    BYTE *pResp )
{
    ULONG *lResp =
        &(( QmiCbkLocEngineStateInd *)pResp)->engineState;

    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    /* Get the parameter from Engine State TLV */
    eRCode = GetLong (pTlvData, lResp);

    return eRCode;
}

/*
 * This function unpacks the Event Engine State message to a
 * user-provided response structure.
 *
 * \param  pMdmResp - Pointer to packed response from the modem.
 *
 * \param  pApiResp - Pointer to storage to unpack into.
 *
 * \return: eQCWWAN_ERR_NONE on success, eQCWWAN_xxx error value otherwise
 */
package enum eQCWWANError UpkQmiCbkLocEngineStateInd(
        BYTE                                 *pMdmResp,
        QmiCbkLocEngineStateInd            *pApiResp )
{
    enum eQCWWANError eRCode;

    static struct qmTlvUnpackerItem map[] =
    {
        { eTLV_IND_ENGINE_STATE,      &UnpackCbkTlvEngineState },
        { eTLV_TYPE_INVALID,          NULL } /* Important. Sentinel.
                                             * Signifies last item in map.
                                             */
    };

    eRCode = qmunpackresp( pMdmResp,
                           (BYTE *)pApiResp,
                           map,
                           eQMI_LOC_EVENT_ENGINE_STATE_IND );
    return eRCode;
}
