/*
 * \ingroup cbk
 *
 * \file    qaCbkImsSLQSPdpStatusInd.c
 *
 * \brief   Contains UnPacking routines for the eQMI_IMSA_PDP_STATUS_IND message.
 *
 * Copyright: © 2015 Sierra Wireless, Inc. all rights reserved
 *
 */

/* include files */

#include "SwiDataTypes.h"
#include "qmudefs.h"
#include "qmerrno.h"
#include "qaCbkImsaSLQSPdpStatusInd.h"
/* Functions */
/*
 * This function unpacks the Connection State TLV parameters from the QMI
 * indication message to a user provided response structure
 *
 * \param   pTlvData - Pointer to TLV data from which to unpack.
 *
 * \param   pResp    - Pointer to structure containing storage
 *                     to return data for this TLV.
 *
 * \return: eQCWWAN_ERR_NONE on success, eQCWWAN_xxx error value otherwise
 */
package enum eQCWWANError UnpackCbkTlvImsConnState(
    BYTE *pTlvData,
    BYTE *pResp )
{
    /* Get the required TLV structure to the local pointer */
    struct QmiCbkImsaPdpStatusInd *lResp =
        (struct QmiCbkImsaPdpStatusInd *)pResp;

    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    /* Extract the IMS PDP connection State */
    eRCode = GetByte( pTlvData, &lResp->PdpConnState );

    return eRCode;
}
/*
 * This function unpacks the ImsFailErrCode TLV parameters from the QMI
 * indication message to a user provided response structure
 *
 * \param   pTlvData - Pointer to TLV data from which to unpack.
 *
 * \param   pResp    - Pointer to structure containing storage
 *                     to return data for this TLV.
 *
 * \return: eQCWWAN_ERR_NONE on success, eQCWWAN_xxx error value otherwise
 */
package enum eQCWWANError UnpackCbkTlvImsFailureErrorCode(
    BYTE *pTlvData,
    BYTE *pResp )
{
    /* Get the required TLV structure to the local pointer */
    struct IMSFailErrCodeTlv *lResp =
        &((struct QmiCbkImsaPdpStatusInd *)pResp)->FailErrCode;

    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    /* Extract the IMS Failure Error Code */
    eRCode = GetLong( pTlvData, &lResp->ImsFailErrCode );
    if( eRCode != eQCWWAN_ERR_NONE )
    {
        return eRCode;
    }

    lResp->TlvPresent   = TRUE;
    return eRCode;
}
/*
 * This function unpacks the IMS PDP Status Indication message to a
 * user-provided response structure.
 *
 * \param   pMdmResp - Pointer to packed response from the modem.
 *
 * \param   pApiResp - Pointer to storage to unpack into.
 *
 * \return: eQCWWAN_ERR_NONE on success, eQCWWAN_xxx error value otherwise
 */
package enum eQCWWANError UpkQmiCbkImsaPdpStatusInd(
    BYTE                            *pMdmResp,
    struct QmiCbkImsaPdpStatusInd *pApiResp )
{
    enum eQCWWANError eRCode;

    static struct qmTlvUnpackerItem map[] =
    {
        { eTLV_PDP_CONNECTION_STATE,   &UnpackCbkTlvImsConnState },
        { eTLV_PDP_FAILURE_ERROR_CODE, &UnpackCbkTlvImsFailureErrorCode },
        { eTLV_TYPE_INVALID,   NULL } /* Important. Sentinel.
                                       * Signifies last item in map.
                                       */
    };

    eRCode = qmunpackresp( pMdmResp,
                           (BYTE *)pApiResp,
                           map,
                           eQMI_IMSA_REGISTRATION_STATUS_IND );
    return eRCode;
}
