/*
 * \ingroup cbk
 *
 * \file    qaCbkImsaSLQSPdpStatusInd.h
 *
 * \brief   This file contains definitions, enumerations, structures and
 *          forward declarations for qaCbkImsaSLQSPdpStatusInd.c
 *
 * Copyright: © 2015 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __IMSA_PDP_STATUS_IND_H_
#define __IMSA_PDP_STATUS_IND_H

#include "qaGobiApiImsa.h"
#include "qaGobiApiCbk.h"

/*
 * An enumeration of eQMI_IMSA_PDP_STATUS_IND response TLV IDs
 */
enum eQMI_IMSA_PDP_STATUS_IND_TLV
{
    eTLV_PDP_CONNECTION_STATE   = 0x01,
    eTLV_PDP_FAILURE_ERROR_CODE = 0x10
};

/*
 * eQMI_IMSA_PDP_STATUS_IND TLV defined below
 */

/*
 * Name:    IMSRegStatusTlv
 *
 * Purpose: Structure used to store IMS Registration Status TLV Value.
 *
 * Members: TlvPresent  - Boolean indicating the presence of the TLV
 *                        in the QMI response
 *
 *          ImsFailErrCode - IMS PDP connection failure error reason code
 */
struct IMSFailErrCodeTlv
{
    BYTE  TlvPresent;
    ULONG ImsFailErrCode;
};

/*
 * Name:    QmiCbkImsaPdpStatusInd
 *
 * Purpose: Structure used to store PDP Status Indication Parameters.
 *
 * Members: PdpConnState and IMSFailErrCodeTlv
 *
 * Note:    None
 */
struct QmiCbkImsaPdpStatusInd{
    BYTE   PdpConnState;
    struct IMSFailErrCodeTlv  FailErrCode;

};

/*
 * Prototypes
 */
enum eQCWWANError UpkQmiCbkImsaPdpStatusInd(
    BYTE                            *pMdmResp,
    struct QmiCbkImsaPdpStatusInd   *pApiResp );

#endif /* __IMSA_PDP_STATUS_IND_H_ */
