/*
 * \ingroup cbk
 *
 * \file    qaCbkDmsSwiGetResetInfoInd.c
 *
 * \brief   Contains UnPacking routines for the
 *          QMI_DMS_SWI_GET_RESET_INFO_IND message.
 *
 * Copyright: © 2016 Sierra Wireless, Inc. all rights reserved
 *
 */

/* include files */

#include "SwiDataTypes.h"
#include "qmudefs.h"
#include "qmerrno.h"
#include "qaCbkDmsSwiGetResetInfoInd.h"

/* Functions */

/*
 * This function unpacks the Temperature TLV from the QMI indication
 * message to a user provided response structure
 *
 * \param   pTlvData - Pointer to TLV data from which to unpack.
 *
 * \param   pResp    - Pointer to structure containing storage
 *                     to return data for this TLV.
 *
 * \return: eQCWWAN_ERR_NONE on success, eQCWWAN_xxx error value otherwise
 */
package enum eQCWWANError UnpackCbkTlvResetInfo(
    BYTE *pTlvData,
    BYTE *pResp )
{
    /* Get the required TLV structure to the local pointer */
    struct ResetInfoInd *lResp =
        &((struct QmiCbkDmsSwiGetResetInfoInd *)pResp)->getResetInfo;

    enum eQCWWANError eRCode = eQCWWAN_ERR_NONE;

    BYTE lByte = 0;

    /* Extract the Temperature State */
    eRCode = GetByte( pTlvData, &lByte );
    if( eRCode != eQCWWAN_ERR_NONE )
    {
        return eRCode;
    }
    lResp->type= lByte;

    /* Extract the Temperature */
    eRCode = GetByte( pTlvData, &lByte );
    if( eRCode != eQCWWAN_ERR_NONE )
    {
        return eRCode;
    }
    lResp->source = lByte;

    return eRCode;
}


/*
 * This function unpacks the Event Report Indication message to a
 * user-provided response structure.
 *
 * \param   pMdmResp - Pointer to packed response from the modem.
 *
 * \param   pApiResp - Pointer to storage to unpack into.
 *
 * \return: eQCWWAN_ERR_NONE on success, eQCWWAN_xxx error value otherwise
 */
package enum eQCWWANError UpkQmiCbkDmsSwiGetResetInfoInd(
    BYTE                                    *pMdmResp,
    struct QmiCbkDmsSwiGetResetInfoInd *pApiResp )
    
{
    enum eQCWWANError eRCode;

    static struct qmTlvUnpackerItem map[] =
    {
        { eTLV_GET_RESET_INFO_IND, &UnpackCbkTlvResetInfo },
        { eTLV_TYPE_INVALID,    NULL } /* Important. Sentinel.
                                        * Signifies last item in map.
                                        */
    };

    eRCode = qmunpackresp( pMdmResp,
                           (BYTE *)pApiResp,
                           map,
                           eQMI_DMS_SWI_GET_RESET_INFO );
    return eRCode;
}

