/*
 * \ingroup cbk
 *
 * \file qaCbkDmsSwiGetResetInfoInd.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaCbkDmsSwiGetResetInfoInd.c
 *
 * Copyright: © 2016 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __DMS_SWI_GET_RESET_INFO_IND_H__
#define __DMS_SWI_GET_RESET_INFO_IND_H__

/*
 * An enumeration of eQMI_DMS_SWI_RESET_INFO_IND response TLV IDs
 *
 */
enum eQMI_DMS_SWI_GET_RESET_INFO_IND
{
    eTLV_GET_RESET_INFO_IND = 0x01
};


/*
 * Name:    VoltageTlv
 *
 * Purpose: Structure used to store Voltage TLV Value.
 *
 * Members: TlvPresent - Boolean indicating the presence of the TLV
 *                       in the QMI response
 *
 *          VoltState  - Voltage State
 *
 *          Voltage    - Voltage (in mV)
 */
struct ResetInfoInd
{
    BYTE type;
    BYTE source;
};

/*
 * Name:    QmiCbkDmsSwiGetResetInfotInd
 *
 * Purpose: Structure used to store all DMS SWI GET RESET INFO Notification
 *          Parameters.
 *
 * Members: resetInfo - check struct ResetInfoInd for more information
 *
 * Note:    None
 */
struct QmiCbkDmsSwiGetResetInfoInd{
    struct ResetInfoInd getResetInfo;
};

/*
 * Prototypes
 *
 */
enum eQCWWANError UpkQmiCbkDmsSwiGetResetInfoInd(
    BYTE                                    *pMdmResp,
    struct QmiCbkDmsSwiGetResetInfoInd *pApiResp );

#endif /* __DMS_SWI_GET_RESET_INFO_IND_H__ */
/*
 * \ingroup cbk
 *
 * \file qaCbkDmsSwiGetResetInfoInd.h
 *
 * \brief This file contains definitions, enumerations, structures and
 *        forward declarations for qaCbkDmsSwiGetResetInfoInd.c
 *
 * Copyright: © 2016 Sierra Wireless, Inc. all rights reserved
 *
 */

#ifndef __DMS_SWI_GET_RESET_INFO_IND_H__
#define __DMS_SWI_GET_RESET_INFO_IND_H__

/*
 * An enumeration of eQMI_DMS_SWI_RESET_INFO_IND response TLV IDs
 *
 */
enum eQMI_DMS_SWI_GET_RESET_INFO_IND
{
    eTLV_GET_RESET_INFO_IND = 0x01
};


/*
 * Name:    VoltageTlv
 *
 * Purpose: Structure used to store Voltage TLV Value.
 *
 * Members: TlvPresent - Boolean indicating the presence of the TLV
 *                       in the QMI response
 *
 *          VoltState  - Voltage State
 *
 *          Voltage    - Voltage (in mV)
 */
struct ResetInfoInd
{
    BYTE type;
    BYTE source;
};

/*
 * Name:    QmiCbkDmsSwiGetResetInfotInd
 *
 * Purpose: Structure used to store all DMS SWI GET RESET INFO Notification
 *          Parameters.
 *
 * Members: resetInfo - check struct ResetInfoInd for more information
 *
 * Note:    None
 */
struct QmiCbkDmsSwiGetResetInfoInd{
    struct ResetInfoInd getResetInfo;
};

/*
 * Prototypes
 *
 */
enum eQCWWANError UpkQmiCbkDmsSwiGetResetInfoInd(
    BYTE                                    *pMdmResp,
    struct QmiCbkDmsSwiGetResetInfoInd *pApiResp );

#endif /* __DMS_SWI_GET_RESET_INFO_IND_H__ */

