/*************
 *
 * Filename:    piBe - Big Endian put and get functions.
 *
 * Purpose:     This file contains all functions for reading and
 *              writing packets in big Endian byte order.
 *              ( QMI protocol is packed in little Endian format).
 *
 * Copyright:     2011 Sierra Wireless, All rights reserved
 *
 **************/
#include "aa/aaglobal.h"
#include "pi/piudefs.h"

/*************
 *
 * Name:     piput16Be - put a 16-bit value into a packet
 *
 * Purpose:  To put a 16-bit value into a packet that is in big endian order
 *           and increment the packet pointer passed the written field
 *
 * Parms:    field - 16-bit field value
 *           packetpp - memory location of the pointer to the packet
 *           where the 16-bit field will be written to
 *
 * Return:   no value
 *
 * Abort:    none
 *
 * Notes:    This function performs no pointer validation.
 *
 **************/
global void piput16Be(swi_uint16 field, swi_uint8 **packetpp)
{
    swi_uint8 *packetp;

    packetp = *packetpp;
    *packetp++ = field >> 8;
    *packetp++ = field;

    *packetpp = packetp;
}

/*************
 *
 * Name:     piget16Be - get a 16-bit value from a packet
 *
 * Purpose:  To get a 16-bit value from a packet that is in big endian
 *           order and increment the packet pointer passed the read field.
 *
 * Parms:    packetpp  - memory location of the pointer to the buffer where
 *                       the 16-bit value will be read from.
 *
 * Return:   16-bit value
 *
 * Abort:    none
 *
 * Notes:    This function performs no pointer validation.
 *
 **************/
global swi_uint16 piget16Be(swi_uint8 **packetpp)
{
    swi_uint16 field;
    swi_uint8 *packetp;

    packetp = *packetpp;

    field = *packetp++;
    field <<= 8;
    field += *packetp++;

    *packetpp = packetp;

    return(field);

}

