/*
 * Filename:  icuproto.h
 *
 * Purpose:   User prototypes for the IC package
 *
 * Copyright: © 2008-2012 Sierra Wireless Inc., all rights reserved
 *
 */

#ifndef icuproto_h
#define icuproto_h

#include "ql/qludefs.h"

/* icsmt_sdk.c */
extern void icsmt_create(
                          struct icsmtcb *icsmtp,
                          char *smtqueuenamep,
                          swi_uint16 smtqueuedepth );
extern void icsmt_send( struct icsmtcb *icsmtp, swi_ulong msg );
extern swi_bool icsmt_rcv( struct icsmtcb *icsmtp,
                           swi_ulong timeout,
                           swi_ulong *msgp );
extern swi_ulong icsmt_getmaxqueued( struct icsmtcb *icsmtp );
extern swi_charp icsmt_getqnamep( struct icsmtcb *icsmtp );

global swi_ulong* icsmt_tail( struct icsmtcb *icsmtp);
global swi_ulong icsmt_empty( struct icsmtcb *icsmtp);

/* icipc_sdk.c */
extern swi_bool icsdk_rcv( struct icipccb *ipccbp,
                           swi_uint8 *ipcbufp,
                           swi_ulong *ipcbuflenp,
                           swi_ulong timeout );
extern swi_bool icsdk_send( struct icipccb *ipccbp,
                            swi_uint8 *ipcbufp,
                            swi_ulong ipcbuflen  );
extern void icinitsdkhndl( struct icipccb *ipccbp,
                           swi_size_t ipcindex,
                           swi_uint8 * chnamep,
                           swi_uint8    modem_index);
extern void icinitipc( void );

/* icticktask_sdk.c   */
extern void ictttickreg(
    struct icsmtcb      *icsmtp,
    swi_ulong          tickmsg,
    struct icttregqblk  *callerregblk,
    swi_ulong          mstimeout );

extern void ictttaskinit( void );

void ictttickdbg();

/* icipc_api.c */
extern swi_bool icapi_rcv( struct icipccb *ipccbp,
                           swi_uint8 *ipcbufp,
                           swi_ulong *ipcbuflenp,
                           swi_ulong timeout );
extern swi_bool icapi_send( struct icipccb *ipccbp,
                            swi_uint8 *ipcbufp,
                            swi_ulong ipcbuflen  );
extern swi_bool icinitapihndl( struct icipccb *ipccbp,
                               swi_size_t ipcindex,
                               swi_uint8 *chnamep,
                               swi_uint8 modem_index );

#endif
