#-------------------------------------------------------------------------------
#
#  Name:
#    gen.mak
#
#  Description:
#    Generic Makefile to build the pkgs/{package}
#
#   The following make targets are available in this makefile:
#
#     all           - make .o and .a image files (default). Test programs are
#                     also built when present
#     clean         - delete object directory and image files
#
#   This file is include with the {package}.mak files using
#
#     include ../gen.mak
#
#   If GDB is to be used, then run the make at the top level with SYMBOLS=ON
#   and this will cause the compiler to create symbolic information in the
#   object files
#
# Copyright (c) 2011-2013 by Sierra Wireless, Incorporated. All Rights Reserved
#-------------------------------------------------------------------------------
#.SUFFIXES:
#-------------------------------------------------------------------------------
ifndef QMI_BUILD_BASE
export QMI_BUILD_BASE:=$(shell until [ -d pkgs ]; do cd ..; done; pwd)
endif

include $(QMI_BUILD_BASE)/pkgs/slqscompile.mak
#-------------------------------------------------------------------------------
# Variable definitions
#-------------------------------------------------------------------------------
BUILDDIR        := $(QMI_BUILD_BASE)/build
OBJSDIR         := $(BUILDDIR)/obj/$(CPU)/pkgs/$(PKG)

BUILDLIBDIR     := $(BUILDDIR)/lib
CORELIBDIR      := $(BUILDLIBDIR)/$(CPU)
SDKLIBDIR       := $(BUILDLIBDIR)/pkgs/sdk/$(CPU)
DCSLIBDIR       := $(BUILDLIBDIR)/$(CPU)
WDSLIBDIR       := $(BUILDLIBDIR)/$(CPU)
SLQSAPILIBDIR   := $(BUILDLIBDIR)/$(CPU)
DMSLIBDIR       := $(BUILDLIBDIR)/$(CPU)
NASLIBDIR       := $(BUILDLIBDIR)/$(CPU)
CBKLIBDIR       := $(BUILDLIBDIR)/$(CPU)
CATLIBDIR       := $(BUILDLIBDIR)/$(CPU)
RMSLIBDIR       := $(BUILDLIBDIR)/$(CPU)
FMSLIBDIR       := $(BUILDLIBDIR)/$(CPU)
SMSLIBDIR       := $(BUILDLIBDIR)/$(CPU)
PDSLIBDIR       := $(BUILDLIBDIR)/$(CPU)
OMADMLIBDIR     := $(BUILDLIBDIR)/$(CPU)
SWIOMADMSLIBDIR := $(BUILDLIBDIR)/$(CPU)
SARLIBDIR       := $(BUILDLIBDIR)/$(CPU)
VOICELIBDIR     := $(BUILDLIBDIR)/$(CPU)
SWILIBDIR       := $(BUILDLIBDIR)/$(CPU)
UIMLIBDIR       := $(BUILDLIBDIR)/$(CPU)
AUDIOLIBDIR     := $(BUILDLIBDIR)/$(CPU)
SWIAUDIOLIBDIR  := $(BUILDLIBDIR)/$(CPU)
QOSLIBDIR       := $(BUILDLIBDIR)/$(CPU)
IMSLIBDIR       := $(BUILDLIBDIR)/$(CPU)
QMILIBDIR       := $(BUILDLIBDIR)/$(CPU)
PACKLIBDIR      := $(BUILDLIBDIR)/$(CPU)
LOCLIBDIR       := $(BUILDLIBDIR)/$(CPU)
IMSALIBDIR      := $(BUILDLIBDIR)/$(CPU)

CORELIB         := $(CORELIBDIR)/libslqscore.a
SDKLIB          := $(SDKLIBDIR)/libslqssdk.a
SLQSAPILIB      := $(SLQSAPILIBDIR)/libslqsapi.a

#
# QMI Services libraries
#
DCSLIB          := $(DCSLIBDIR)/libdcs.a
WDSLIB          := $(WDSLIBDIR)/libwds.a
DMSLIB          := $(DMSLIBDIR)/libdms.a
NASLIB          := $(NASLIBDIR)/libnas.a
CBKLIB          := $(CBKLIBDIR)/libcbk.a
CATLIB          := $(CATLIBDIR)/libcat.a
RMSLIB          := $(RMSLIBDIR)/librms.a
FMSLIB          := $(FMSLIBDIR)/libfms.a
SMSLIB          := $(SMSLIBDIR)/libsms.a
PDSLIB          := $(PDSLIBDIR)/libpds.a
OMADMLIB        := $(OMADMLIBDIR)/libomadm.a
SWIOMADMSLIB    := $(SWIOMADMSLIBDIR)/libswiomadms.a
SARLIB          := $(SARLIBDIR)/libsar.a
VOICELIB        := $(VOICELIBDIR)/libvoice.a
UIMLIB          := $(UIMLIBDIR)/libuim.a
AUDIOLIB        := $(AUDIOLIBDIR)/libaudio.a
IMSLIB          := $(IMSLIBDIR)/libims.a
SWIAUDIOLIB     := $(SWIAUDIOLIBDIR)/libswiaudio.a
LOCLIB          := $(LOCLIBDIR)/libloc.a
IMSALIB         := $(IMSALIBDIR)/libimsa.a

SWILIB          := $(SWILIBDIR)/libswi.a
QOSLIB          := $(SWILIBDIR)/libqos.a

#
# Sum of all QMI Services
#
QMILIB          := $(QMILIBDIR)/libslqsqmi.a
PACKLIB         := $(PACKLIBDIR)/libpack.a

# -------------------------------------------------------
# Build required programs, $(CPU)/slqssdk and qatest$(CPU)
#--------------------------------------------------------
TESTSRC = $(PKG)test.c
have_testsrc := $(wildcard $(TESTSRC))
ifeq ($(strip $(have_testsrc)),sdktest.c)
TESTOBJ = $(OBJSDIR)/$(PKG)test.o
TESTEXE = $(CPU)/slqs$(PKG)
else
ifeq ($(TESTSRC),qatest.c)
TESTSRC = src/qatest.c
TESTOBJ = $(OBJSDIR)/$(PKG)test.o
TESTEXE = $(PKG)test$(CPU)
endif
endif
#
# extract current directory name for special processing of some files
#
CURRENT_DIR = $(notdir $(PWD))
#
#-------------------------------------------------------------------------------
# Default Target
#-------------------------------------------------------------------------------
all:	$(OBJS)\
$(CORELIB) $(SDKLIB)  \
$(DCSLIB) \
$(WDSLIB) \
$(DMSLIB) \
$(NASLIB) \
$(CBKLIB) \
$(CATLIB) \
$(RMSLIB) \
$(FMSLIB) \
$(SMSLIB) \
$(PDSLIB) \
$(OMADMLIB) \
$(SWIOMADMSLIB) \
$(SARLIB) \
$(VOICELIB) \
$(SWILIB) \
$(UIMLIB) \
$(AUDIOLIB) \
$(IMSLIB) \
$(SWIAUDIOLIB) \
$(QOSLIB) \
$(LOCLIB) \
$(IMSALIB) \
$(QMILIB) \
$(PACKLIB) \
$(SLQSAPILIB) \
$(TESTEXE) $(SDKTESTEXE) $(APITESTEXE)

$(OBJS): $(OBJSDIR)/%.o:%.c $(HDRS)
ifeq ($(VERBOSE),0)
	@echo "--- Building $(basename $<)"
else
	@echo "QMI Build base: $(QMI_BUILD_BASE)"
	@echo $(INCLUDE) $(LDFLAGS)
	@echo "============================"
	@echo "--- Building  $(PKG) for $(CPU)..."
	@echo "----------------------------"
endif
	@if [ ! -d $(OBJSDIR) ] ; then mkdir -p $(OBJSDIR) ; fi;
ifeq ($(DEF_ULONG_AS_UINT),0)
	$(CC) $(CFLAGS) $(SLQSFLAG) $(INCLUDE) $< -o $@ 
else
	$(CC) $(CFLAGS) -DULONG_AS_UINT $(SLQSFLAG) $(INCLUDE) $< -o $@ 
endif

#--
# When timestamp resolution is in seconds, it is possible that refreshly compiled object files
# has the same timestamp as target library.
# Ref: http://www.gnu.org/software/autoconf/manual/autoconf-2.64/html_node/Timestamps-and-Make.html
# Force archiving work around this issue
#--
.PHONY: $(CORELIB) $(SDKLIB) $(SLQSAPILIB) $(PACKLIB)

$(CORELIB): $(COREOBJ)
ifeq ($(VERBOSE),0)
	@echo "--- Archiving  $(CORELIB)..."
else
	@echo "--------------------------------------------"
	@echo "--- Archiving $(COREOBJ) to $(CORELIB)..."
	@echo "--------------------------------------------"
endif
	@if [ ! -d $(CORELIBDIR) ] ; then mkdir -p $(CORELIBDIR) ; fi;
	$(AR) rvu $(CORELIB) $(COREOBJ) > $(OUTPUT) || (echo "AR $(CORELIB) $$?"; exit 1)
	$(RANLIB) $(CORELIB) || (echo "RNLIB $(CORELIB) $$?"; exit 1)

$(SDKLIB): $(SDKOBJ)
ifeq ($(VERBOSE),0)
	@echo "--- Archiving $(SDKLIB)..."
else
	@echo "--------------------------------------------"
	@echo "--- Archiving $(SDKOBJ) to $(SDKLIB)..."
	@echo "--------------------------------------------"
endif
	@if [ ! -d $(SDKLIBDIR) ] ; then mkdir -p $(SDKLIBDIR) ; fi;
	$(AR) rvu $(SDKLIB) $(SDKOBJ) > $(OUTPUT) || (echo "AR $(SDKLIB) $$?"; exit 1)
	$(RANLIB) $(SDKLIB) || (echo "RANLIB $(SDKLIB) $$?"; exit 1)

$(DCSLIB): $(DCSOBJ)
ifeq ($(VERBOSE),0)
	@echo "--- Archiving $(DCSLIB)..."
else
	@echo "--------------------------------------------"
	@echo "--- Archiving $(DCSOBJ) to $(DCSLIB)..."
	@echo "--------------------------------------------"
endif
	@if [ ! -d $(DCSLIBDIR) ] ; then mkdir -p $(DCSLIBDIR) ; fi;
	$(AR) rvu $(DCSLIB) $(DCSOBJ)  > $(OUTPUT) || (echo "AR $(DCSLIB) $$?"; exit 1)
	$(RANLIB) $(DCSLIB) || (echo "RANLIB $(DCSLIB) $$?"; exit 1)

$(WDSLIB): $(WDSOBJ)
ifeq ($(VERBOSE),0)
	@echo "--- Archiving $(WDSLIB)..."
else
	@echo "--------------------------------------------"
	@echo "--- Archiving $(WDSOBJ) to $(WDSLIB)..."
	@echo "--------------------------------------------"
endif
	@if [ ! -d $(WDSLIBDIR) ] ; then mkdir -p $(WDSLIBDIR) ; fi;
	$(AR) rvu $(WDSLIB)  $(WDSOBJ) > $(OUTPUT) || (echo "AR $(WDSLIB) $$?"; exit 1)
	$(RANLIB) $(WDSLIB) || (echo "RANLIB $(WDSLIB) $$?"; exit 1)

$(DMSLIB): $(DMSOBJ)
ifeq ($(VERBOSE),0)
	@echo "--- Archiving $(DMSLIB)..."
else
	@echo "--------------------------------------------"
	@echo "--- Archiving $(DMSOBJ) to $(DMSLIB)..."
	@echo "--------------------------------------------"
endif
	@if [ ! -d $(DMSLIBDIR) ] ; then mkdir -p $(DMSLIBDIR) ; fi;
	$(AR) rvu $(DMSLIB) $(DMSOBJ) > $(OUTPUT) || (echo "AR $(DMSLIBDIR) $$?"; exit 1)
	$(RANLIB) $(DMSLIB) || (echo "RANLIB $(DMSLIB) $$?"; exit 1)

$(NASLIB): $(NASOBJ)
ifeq ($(VERBOSE),0)
	@echo "--- Archiving $(NASLIB)..."
else
	@echo "--------------------------------------------"
	@echo "--- Archiving $(NASOBJ) to $(NASLIB)..."
	@echo "--------------------------------------------"
endif
	@if [ ! -d $(NASLIBDIR) ] ; then mkdir -p $(NASLIBDIR) ; fi;
	$(AR) rvu $(NASLIB) $(NASOBJ) > $(OUTPUT) || (echo "AR $(NASLIB) $$?"; exit 1)
	$(RANLIB) $(NASLIB) || (echo "RANLIB $(NASLIB) $$?"; exit 1)

$(CBKLIB): $(CBKOBJ)
ifeq ($(VERBOSE),0)
	@echo "--- Archiving $(CBKLIB)..."
else
	@echo "--------------------------------------------"
	@echo "--- Archiving $(CBKOBJ) to $(CBKLIB)..."
	@echo "--------------------------------------------"
endif
	@if [ ! -d $(CBKLIBDIR) ] ; then mkdir -p $(CBKLIBDIR) ; fi;
	$(AR) rvu $(CBKLIB) $(CBKOBJ) > $(OUTPUT) || (echo "AR $(CBKLIB) $$?"; exit 1)
	$(RANLIB) $(CBKLIB) || (echo "RANLIB $(CBKLIB) $$?"; exit 1)

$(RMSLIB): $(RMSOBJ)
ifeq ($(VERBOSE),0)
	@echo "--- Archiving $(CBKLIB)..."
else
	@echo "--------------------------------------------"
	@echo "--- Archiving $(RMSOBJ) to $(RMSLIB)..."
	@echo "--------------------------------------------"
endif
	@if [ ! -d $(RMSLIBDIR) ] ; then mkdir -p $(RMSLIBDIR) ; fi;
	$(AR) rvu $(RMSLIB) $(RMSOBJ) > $(OUTPUT) || (echo "AR $(RMSLIB) $$?"; exit 1)
	$(RANLIB) $(RMSLIB) || (echo "RANLIB $(RMSLIB) $$?"; exit 1)

$(CATLIB): $(CATOBJ)
ifeq ($(VERBOSE),0)
	@echo "--- Archiving $(CATLIB)..."
else
	@echo "--------------------------------------------"
	@echo "--- Archiving $(CATOBJ) to $(CATLIB)..."
	@echo "--------------------------------------------"
endif
	@if [ ! -d $(CATLIBDIR) ] ; then mkdir -p $(CATLIBDIR) ; fi;
	$(AR) rvu $(CATLIB) $(CATOBJ) > $(OUTPUT) || (echo "AR $(CATLIB) $$?"; exit 1)
	$(RANLIB) $(CATLIB) || (echo "RANLIB $(CATLIB) $$?"; exit 1)

$(FMSLIB): $(FMSOBJ)
ifeq ($(VERBOSE),0)
	@echo "--- Archiving $(FMSLIB)..."
else
	@echo "--------------------------------------------"
	@echo "--- Archiving $(FMSOBJ) to $(FMSLIB)..."
	@echo "--------------------------------------------"
endif
	@if [ ! -d $(FMSLIBDIR) ] ; then mkdir -p $(FMSLIBDIR) ; fi;
	$(AR) rvu $(FMSLIB) $(FMSOBJ) > $(OUTPUT) || (echo "AR $(FMSLIB) $$?"; exit 1)
	$(RANLIB) $(FMSLIB) || (echo "RANLIB $(FMSLIB) $$?"; exit 1)

$(SMSLIB): $(SMSOBJ)
ifeq ($(VERBOSE),0)
	@echo "--- Archiving $(SMSLIB)..."
else
	@echo "--------------------------------------------"
	@echo "--- Archiving $(SMSOBJ) to $(SMSLIB)..."
	@echo "--------------------------------------------"
endif
	@if [ ! -d $(SMSLIBDIR) ] ; then mkdir -p $(SMSLIBDIR) ; fi;
	$(AR) rvu $(SMSLIB) $(SMSOBJ) > $(OUTPUT) || (echo "AR $(SMSLIB) $$?"; exit 1)
	$(RANLIB) $(SMSLIB) > $(OUTPUT)|| (echo "RANLIB $(SMSLIB) $$?"; exit 1)

$(PDSLIB): $(PDSOBJ)
ifeq ($(VERBOSE),0)
	@echo "--- Archiving $(PDSLIB)..."
else
	@echo "--------------------------------------------"
	@echo "--- Archiving $(PDSOBJ) to $(PDSLIB)..."
	@echo "--------------------------------------------"
endif
	@if [ ! -d $(PDSLIBDIR) ] ; then mkdir -p $(PDSLIBDIR) ; fi;
	$(AR) rvu $(PDSLIB) $(PDSOBJ) > $(OUTPUT) || (echo "AR $(PDSLIB) $$?"; exit 1)
	$(RANLIB) $(PDSLIB) || (echo "RANLIB $(PDSLIB) $$?"; exit 1)

$(OMADMLIB): $(OMADMOBJ)
ifeq ($(VERBOSE),0)
	@echo "--- Archiving $(OMADMLIB)..."
else
	@echo "--------------------------------------------"
	@echo "--- Archiving $(OMADMOBJ) to $(OMADMLIB)..."
	@echo "--------------------------------------------"
endif
	@if [ ! -d $(OMADMLIBDIR) ] ; then mkdir -p $(OMADMLIBDIR) ; fi;
	$(AR) rvu $(OMADMLIB) $(OMADMOBJ) > $(OUTPUT) || (echo "AR $(OMADMLIB) $$?"; exit 1)
	$(RANLIB) $(OMADMLIB) || (echo "RANLIB $(OMADMLIB) $$?"; exit 1)

$(SWIOMADMSLIB): $(SWIOMADMSOBJ)
ifeq ($(VERBOSE),0)
	@echo "--- Archiving $(OMADMLIB)..."
else
	@echo "--------------------------------------------"
	@echo "--- Archiving $(SWIOMADMSOBJ) to $(SWIOMADMSLIB)..."
	@echo "--------------------------------------------"
endif
	@if [ ! -d $(SWIOMADMSLIBDIR) ] ; then mkdir -p $(SWIOMADMSLIBDIR) ; fi;
	$(AR) rvu $(SWIOMADMSLIB) $(SWIOMADMSOBJ) > $(OUTPUT) || (echo "AR $(SWIOMADMSLIB) $$?"; exit 1)
	$(RANLIB) $(SWIOMADMSLIB) || (echo "RANLIB $(SWIOMADMSLIB) $$?"; exit 1)

$(SARLIB): $(SAROBJ)
ifeq ($(VERBOSE),0)
	@echo "--- Archiving $(SARLIB)..."
else
	@echo "--------------------------------------------"
	@echo "--- Archiving $(SAROBJ) to $(SARLIB)..."
	@echo "--------------------------------------------"
endif
	@if [ ! -d $(SARLIBDIR) ] ; then mkdir -p $(SARLIBDIR) ; fi;
	$(AR) rvu $(SARLIB) $(SAROBJ) > $(OUTPUT) || (echo "AR $(SARLIB) $$?"; exit 1)
	$(RANLIB) $(SARLIB) || (echo "RANLIB $(SARLIB) $$?"; exit 1)

$(VOICELIB): $(VOICEOBJ)
ifeq ($(VERBOSE),0)
	@echo "--- Archiving $(VOICELIB)..."
else
	@echo "--------------------------------------------"
	@echo "--- Archiving $(VOICEOBJ) to $(VOICELIB)..."
	@echo "--------------------------------------------"
endif
	@if [ ! -d $(VOICELIBDIR) ] ; then mkdir -p $(VOICELIBDIR) ; fi;
	$(AR) rvu $(VOICELIB) $(VOICEOBJ) > $(OUTPUT) || (echo "AR $(VOICELIB) $$?"; exit 1)
	$(RANLIB) $(VOICELIB) || (echo "RANLIB $(VOICELIB) $$?"; exit 1)

$(SWILIB): $(SWIOBJ)
ifeq ($(VERBOSE),0)
	@echo "--- Archiving $(SWILIB)..."
else
	@echo "--------------------------------------------"
	@echo "--- Archiving $(SWIOBJ) to $(SWILIB)..."
	@echo "--------------------------------------------"
endif
	@if [ ! -d $(SWILIBDIR) ] ; then mkdir -p $(SWILIBDIR) ; fi;
	$(AR) rvu $(SWILIB) $(SWIOBJ) > $(OUTPUT) || (echo "AR $(SWILIB) $$?"; exit 1)
	$(RANLIB) $(SWILIB) || (echo "RANLIB $(SWILIB) $$?"; exit 1)

$(UIMLIB): $(UIMOBJ)
ifeq ($(VERBOSE),0)
	@echo "--- Archiving $(UIMLIB)..."
else
	@echo "--------------------------------------------"
	@echo "--- Archiving $(UIMOBJ) to $(UIMLIB)..."
	@echo "--------------------------------------------"
endif
	@if [ ! -d $(UIMLIBDIR) ] ; then mkdir -p $(UIMLIBDIR) ; fi;
	$(AR) rvu $(UIMLIB) $(UIMOBJ) > $(OUTPUT) || (echo "AR $(UIMLIB) $$?"; exit 1)
	$(RANLIB) $(UIMLIB) || (echo "RANLIB $(UIMLIB) $$?"; exit 1)

$(AUDIOLIB): $(AUDIOOBJ)
ifeq ($(VERBOSE),0)
	@echo "--- Archiving $(UIMLIB)..."
else
	@echo "--------------------------------------------"
	@echo "--- Archiving $(AUDIOOBJ) to $(AUDIOLIB)..."
	@echo "--------------------------------------------"
endif
	@if [ ! -d $(AUDIOLIBDIR) ] ; then mkdir -p $(AUDIOLIBDIR) ; fi;
	$(AR) rvu $(AUDIOLIB) $(AUDIOOBJ) > $(OUTPUT) || (echo "AR $(AUDIOLIB) $$?"; exit 1)
	$(RANLIB) $(AUDIOLIB) || (echo "RANLIB $(AUDIOLIB) $$?"; exit 1)

$(IMSLIB): $(IMSOBJ)
ifeq ($(VERBOSE),0)
	@echo "--- Archiving $(IMSLIB)..."
else
	@echo "--------------------------------------------"
	@echo "--- Archiving $(IMSOBJ) to $(IMSLIB)..."
	@echo "--------------------------------------------"
endif
	@if [ ! -d $(IMSLIBDIR) ] ; then mkdir -p $(IMSLIBDIR) ; fi;
	$(AR) rvu $(IMSLIB) $(IMSOBJ) > $(OUTPUT) || (echo "AR $(IMSLIB) $$?"; exit 1)
	$(RANLIB) $(IMSLIB) || (echo "RANLIB $(IMSLIB) $$?"; exit 1)

$(SWIAUDIOLIB): $(SWIAUDIOOBJ)
ifeq ($(VERBOSE),0)
	@echo "--- Archiving $(SWIAUDIOLIB)..."
else
	@echo "--------------------------------------------"
	@echo "--- Archiving $(SWIAUDIOOBJ) to $(SWIAUDIOLIB)..."
	@echo "--------------------------------------------"
endif
	@if [ ! -d $(SWIAUDIOLIBDIR) ] ; then mkdir -p $(SWIAUDIOLIBDIR) ; fi;
	$(AR) rvu $(SWIAUDIOLIB) $(SWIAUDIOOBJ) > $(OUTPUT) || (echo "AR $(SWIAUDIOLIB) $$?"; exit 1)
	$(RANLIB) $(SWIAUDIOLIB) || (echo "RANLIB $(SWIAUDIOLIB) $$?"; exit 1)

$(QOSLIB): $(QOSOBJ)
ifeq ($(VERBOSE),0)
	@echo "--- Archiving $(QOSLIB)..."
else
	@echo "--------------------------------------------"
	@echo "--- Archiving $(QOSOBJ) to $(QOSLIB)..."
	@echo "--------------------------------------------"
endif
	@if [ ! -d $(LIBDIR) ] ; then mkdir -p $(QOSLIBDIR) ; fi;
	$(AR) rvu $(QOSLIB) $(QOSOBJ) > $(OUTPUT) || (echo "AR $(QOSLIB) $$?"; exit 1)
	$(RANLIB) $(QOSLIB) || (echo "RANLIB $(QOSLIB) $$?"; exit 1)

$(LOCLIB): $(LOCOBJ)
ifeq ($(VERBOSE),0)
	@echo "--- Archiving $(LOCLIB)..."
else
	@echo "--------------------------------------------"
	@echo "--- Archiving $(LOCOBJ) to $(LOCLIB)..."
	@echo "--------------------------------------------"
endif
	@if [ ! -d $(LOCLIBDIR) ] ; then mkdir -p $(LOCLIBDIR) ; fi;
	$(AR) rvu $(LOCLIB) $(LOCOBJ) > $(OUTPUT) || (echo "AR $(LOCLIB) $$?"; exit 1)
	$(RANLIB) $(LOCLIB) || (echo "RANLIB $(LOCLIB) $$?"; exit 1)

$(IMSALIB): $(IMSAOBJ)
ifeq ($(VERBOSE),0)
	@echo "--- Archiving $(IMSALIB)..."
else
	@echo "--------------------------------------------"
	@echo "--- Archiving $(IMSAOBJ) to $(IMSALIB)..."
	@echo "--------------------------------------------"
endif
	@if [ ! -d $(IMSALIBDIR) ] ; then mkdir -p $(IMSALIBDIR) ; fi;
	$(AR) rvu $(IMSALIB) $(IMSAOBJ) > $(OUTPUT) || (echo "AR $(IMSALIB) $$?"; exit 1)
	$(RANLIB) $(IMSALIB) || (echo "RANLIB $(LOCLIB) $$?"; exit 1)

$(SLQSAPILIB): $(SLQSAPIOBJ) $(WDSOBJ) $(DMSOBJ) $(QOSOBJ)
ifeq ($(VERBOSE),0)
	@echo "--- Archiving $(SLQSAPILIB)..."
else
	@echo "--------------------------------------------"
	@echo "--- Archiving $(SLQSAPIOBJ) to $(SLQSAPILIB)..."
	@echo "--------------------------------------------"
endif
	@if [ ! -d $(SLQSAPILIBDIR) ] ; then mkdir -p $(SLQSAPILIBDIR) ; fi;
	$(AR) rvu $(SLQSAPILIB) $(SLQSAPIOBJ) $(FMSOBJ) $(WDSOBJ) $(DMSOBJ) $(QOSOBJ) > $(OUTPUT) || (echo "AR $(SLQSAPILIB) $$?"; exit 1)
	$(RANLIB) $(SLQSAPILIB)  || (echo "RANLIB $(LOCLIB) $$?"; exit 1)

$(QMILIB): $(DCSOBJ) $(WDSOBJ) $(DMSOBJ) $(NASOBJ) $(CBKOBJ) $(CATOBJ) \
			$(RMSOBJ) $(FMSOBJ) $(SMSOBJ) $(PDSOBJ) $(SWIOMADMSOBJ) $(OMADMOBJ) \
			$(SAROBJ) $(VOICEOBJ) $(SWIOBJ) $(UIMOBJ) $(QOSOBJ) $(AUDIOOBJ) \
			$(IMSOBJ) $(SWIAUDIOOBJ) $(LOCOBJ) $(IMSAOBJ)
ifeq ($(VERBOSE),0)
	@echo "--- Archiving $(SLQSAPILIB)..."
else
	@echo "--------------------------------------------"
	@echo "--- Archiving to $(QMILIB)..."
	@echo "--------------------------------------------"
endif
	@if [ ! -d $(QMILIBDIR) ] ; then mkdir -p $(QMILIBDIR) ; fi;
	$(AR) rvu $(QMILIB) $(DCSOBJ) $(WDSOBJ) $(DMSOBJ) $(NASOBJ) $(CBKOBJ) > $(OUTPUT) || (echo "AR $(QMILIB) $$?"; exit 1)
	$(AR) rvu $(QMILIB) $(CATOBJ) $(RMSOBJ) $(FMSOBJ) $(SMSOBJ) $(PDSOBJ) > $(OUTPUT) || (echo "AR $(QMILIB) $$?"; exit 1)
	$(AR) rvu $(QMILIB) $(SWIOMADMSOBJ) $(OMADMOBJ) $(SAROBJ) $(VOICEOBJ) $(SWIOBJ) > $(OUTPUT) || (echo "AR $(QMILIB) $$?"; exit 1)
	$(AR) rvu $(QMILIB) $(UIMOBJ) $(QOSOBJ) $(AUDIOOBJ) $(IMSOBJ) $(SWIAUDIOOBJ) $(LOCOBJ) $(IMSAOBJ)> $(OUTPUT) || (echo "AR $(QMILIB) $$?"; exit 1)
	$(RANLIB) $(QMILIB) || (echo "RANLIB $(QMILIB) $$?"; exit 1)

$(PACKLIB): $(DCSOBJ) $(WDSOBJ) $(DMSOBJ) $(NASOBJ) $(CBKOBJ) $(CATOBJ) \
			$(RMSOBJ) $(FMSOBJ) $(SMSOBJ) $(PDSOBJ) $(SWIOMADMSOBJ) $(OMADMOBJ) \
			$(SAROBJ) $(VOICEOBJ) $(SWIOBJ) $(UIMOBJ) $(QOSOBJ) $(AUDIOOBJ) \
			$(IMSOBJ) $(SWIAUDIOOBJ) $(LOCOBJ) $(IMSAOBJ) \
			$(SLQSAPIOBJ) $(WDSOBJ) $(DMSOBJ) $(QOSOBJ) \
			$(COREOBJ) \
			$(CKBOBJ) 
ifeq ($(VERBOSE),0)
	@echo "--- Archiving $(PACKLIB)..."
else
	@echo "--------------------------------------------"
	@echo "--- Archiving to $(PACKLIB)..."
	@echo "--------------------------------------------"
endif
	@if [ ! -d $(PACKLIBDIR) ] ; then mkdir -p $(PACKLIBDIR) ; fi;
	$(AR) rvu $(PACKLIB) $(DCSOBJ) $(WDSOBJ) $(DMSOBJ) $(NASOBJ) $(CBKOBJ) > $(OUTPUT) || (echo "AR $(PACKLIB) $$?"; exit 1)
	$(AR) rvu $(PACKLIB) $(CATOBJ) $(RMSOBJ) $(FMSOBJ) $(SMSOBJ) $(PDSOBJ) > $(OUTPUT) || (echo "AR $(PACKLIB) $$?"; exit 1)
	$(AR) rvu $(PACKLIB) $(SWIOMADMSOBJ) $(OMADMOBJ) $(SAROBJ) $(VOICEOBJ) $(SWIOBJ) > $(OUTPUT) || (echo "AR $(PACKLIB) $$?"; exit 1)
	$(AR) rvu $(PACKLIB) $(UIMOBJ) $(QOSOBJ) $(AUDIOOBJ) $(IMSOBJ) $(SWIAUDIOOBJ) $(LOCOBJ) $(IMSAOBJ)> $(OUTPUT) || (echo "AR $(PACKLIB) $$?"; exit 1)
	$(AR) rvu $(PACKLIB) $(SLQSAPIOBJ) $(WDSOBJ) $(DMSOBJ) $(QOSOBJ) > $(OUTPUT) || (echo "AR $(PACKLIB) $$?"; exit 1)
	$(AR) rvu $(PACKLIB) $(COREOBJ) > $(OUTPUT) || (echo "AR $(PACKLIB) $$?"; exit 1)
	$(AR) rvu $(PACKLIB) $(CKBOBJ) > $(OUTPUT) || (echo "AR $(PACKLIB) $$?"; exit 1)
	$(RANLIB) $(PACKLIB) || (echo "RANLIB $(PACKLIB) $$?"; exit 1)

#-------------------------------------------------------------------------------
# Test Targets
#-------------------------------------------------------------------------------
#
$(TESTEXE):  $(TESTSRC) $(OBJS) $(SDKLIB) $(CORELIB) $(SLQSAPILIB) $(HDRS)
	@echo "--------------------------"
	@echo "--- Building $(TESTEXE)..."
	@echo "--------------------------"
	@if [ ! -d $(CPU) ] ; then mkdir -p $(CPU) ; fi ;
ifeq ($(LIBPACK),0)
	-$(CC) $(INCLUDE) $(SLQSFLAG) $(TESTSRC) $(TESTLIBS) \
	$(LDFLAGS) -DSDK_EXE='"$(SDK_EXE)"'\
	$(DBGFLAGS) -o $(TESTEXE)
endif
#
#--------------------------------------------------------------------------------
# Clean files
#--------------------------------------------------------------------------------
.PHONY: clean
clean:
	@echo "Cleaning $(PKG) files..."
	rm -fr $(OBJSDIR)/*.o

.PHONY: debug
debug:
	@echo "CFLAGS="$(CFLAGS)
